/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.message;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.activemq.message.ActiveMQMessage;

public class ActiveMQMapMessage
extends ActiveMQMessage
implements MapMessage {
    private HashMap theTable;

    public int getPacketType() {
        return 11;
    }

    public ActiveMQMessage shallowCopy() throws JMSException {
        ActiveMQMapMessage other = new ActiveMQMapMessage();
        this.initializeOther(other);
        other.theTable = this.theTable;
        return other;
    }

    public ActiveMQMessage deepCopy() throws JMSException {
        ActiveMQMapMessage other = new ActiveMQMapMessage();
        this.initializeOther(other);
        if (this.theTable != null) {
            other.theTable = new HashMap(this.theTable);
        }
        return other;
    }

    public void setTable(HashMap newTable) {
        this.theTable = newTable;
    }

    public HashMap getTable() throws JMSException {
        if (this.theTable == null) {
            try {
                super.buildBodyFromBytes();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("building table from data failed");
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
        }
        if (this.theTable == null) {
            this.theTable = new HashMap();
        }
        return this.theTable;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.getTable().clear();
    }

    public boolean getBoolean(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read a boolean from " + value.getClass().getName());
    }

    public byte getByte(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read a byte from " + value.getClass().getName());
    }

    public short getShort(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof String) {
            return Short.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read a short from " + value.getClass().getName());
    }

    public char getChar(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException(" cannot read a short from " + value.getClass().getName());
    }

    public int getInt(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read an int from " + value.getClass().getName());
    }

    public long getLong(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf(value.toString());
        }
        throw new MessageFormatException(" cannot read a long from " + value.getClass().getName());
    }

    public float getFloat(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf(value.toString()).floatValue();
        }
        throw new MessageFormatException(" cannot read a float from " + value.getClass().getName());
    }

    public double getDouble(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf(value.toString()).floatValue();
        }
        throw new MessageFormatException(" cannot read a double from " + value.getClass().getName());
    }

    public String getString(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            throw new MessageFormatException("Use getBytes to read a byte array");
        }
        return value.toString();
    }

    public byte[] getBytes(String name) throws JMSException {
        Object value = this.getTable().get(name);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new MessageFormatException(" cannot read a byte[] from " + value.getClass().getName());
    }

    public Object getObject(String name) throws JMSException {
        return this.getTable().get(name);
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.getTable().keySet());
    }

    protected void put(String name, Object value) throws JMSException {
        if (name == null) {
            throw new IllegalArgumentException("The name of the property cannot be null.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("The name of the property cannot be an emprty string.");
        }
        this.getTable().put(name, value);
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        this.initializeWriting();
        this.put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setByte(String name, byte value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Byte(value));
    }

    public void setShort(String name, short value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Short(value));
    }

    public void setChar(String name, char value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Character(value));
    }

    public void setInt(String name, int value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Integer(value));
    }

    public void setLong(String name, long value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Long(value));
    }

    public void setFloat(String name, float value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Float(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        this.initializeWriting();
        this.put(name, new Double(value));
    }

    public void setString(String name, String value) throws JMSException {
        this.initializeWriting();
        this.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        this.initializeWriting();
        if (value != null) {
            this.put(name, value);
        } else {
            this.getTable().remove(name);
        }
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        byte[] data = new byte[length];
        System.arraycopy(value, offset, data, 0, length);
        this.put(name, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(String name, Object value) throws JMSException {
        this.initializeWriting();
        if (value != null) {
            if (!(value instanceof Number) && !(value instanceof String) && !(value instanceof Boolean) && !(value instanceof Byte) && !(value instanceof Character) && !(value instanceof byte[])) throw new MessageFormatException(value.getClass() + " is not a primitive type");
            this.put(name, value);
            return;
        } else {
            this.put(name, null);
        }
    }

    public void writeBody(DataOutput dataOut) throws IOException {
        super.writeMapProperties(this.theTable, dataOut);
        this.theTable = null;
    }

    public void readBody(DataInput dataIn) throws IOException {
        this.theTable = super.readMapProperties(dataIn);
    }

    public boolean itemExists(String name) throws JMSException {
        return this.getTable().containsKey(name);
    }

    private void initializeWriting() throws MessageNotWriteableException {
        if (this.readOnlyMessage) {
            throw new MessageNotWriteableException("This message is in read-only mode");
        }
    }

    public String toString() {
        return super.toString() + " ActiveMQMapMessage{ " + "theTable = " + this.theTable + " }";
    }
}

