/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.activemq.broker.BrokerClient;
import org.activemq.filter.DestinationFilter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.service.MessageContainerManager;
import org.activemq.service.impl.ProxyMessageContainerManager;

public class InitialImageMessageContainerManager
extends ProxyMessageContainerManager {
    private Map cache;
    private boolean topic;
    private DestinationFilter destinationFilter;

    public InitialImageMessageContainerManager(MessageContainerManager delegate, Map cache, DestinationFilter destinationFilter) {
        this(delegate, cache, true, destinationFilter);
    }

    public InitialImageMessageContainerManager(MessageContainerManager delegate, Map cache, boolean topic, DestinationFilter destinationFilter) {
        super(delegate);
        this.cache = cache;
        this.topic = topic;
        this.destinationFilter = destinationFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        super.addMessageConsumer(client, info);
        ActiveMQDestination destination = info.getDestination();
        if (this.isValid(destination)) {
            if (destination.isWildcard()) {
                DestinationFilter filter = DestinationFilter.parseFilter(destination);
                this.sendMatchingInitialImages(client, info, filter);
            } else {
                ActiveMQMessage message = null;
                Map map = this.cache;
                synchronized (map) {
                    message = (ActiveMQMessage)this.cache.get(destination);
                }
                if (message != null) {
                    this.sendMessage(client, message);
                }
            }
        }
    }

    public void sendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        ActiveMQDestination destination = message.getJMSActiveMQDestination();
        if (this.isValid(destination)) {
            this.cache.put(destination, message);
        }
        super.sendMessage(client, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMatchingInitialImages(BrokerClient client, ConsumerInfo info, DestinationFilter filter) throws JMSException {
        Map map = this.cache;
        synchronized (map) {
            Iterator iter = this.cache.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Destination destination = (Destination)entry.getKey();
                if (!filter.matches(destination)) continue;
                ActiveMQMessage message = (ActiveMQMessage)entry.getValue();
                this.sendMessage(client, message);
            }
        }
    }

    protected boolean isValid(ActiveMQDestination destination) {
        return destination.isTopic() == this.topic && (this.destinationFilter == null || this.destinationFilter.matches(destination));
    }
}

