/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisories;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.activemq.advisories.ConsumerAdvisoryEvent;
import org.activemq.advisories.ConsumerAdvisoryEventListener;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ConsumerInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsumerAdvisor
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)ConsumerAdvisor.class);
    private Connection connection;
    private ActiveMQDestination destination;
    private Session session;
    private List listeners = new CopyOnWriteArrayList();
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private Map activeSubscribers = new ConcurrentHashMap();

    public ConsumerAdvisor(Connection connection, Destination destination) throws JMSException {
        this.connection = connection;
        this.destination = ActiveMQDestination.transformDestination(destination);
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.session = this.connection.createSession(false, 1);
            MessageConsumer consumer = this.session.createConsumer((Destination)this.destination.getTopicForConsumerAdvisory());
            consumer.setMessageListener((MessageListener)this);
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false) && this.session != null) {
            this.session.close();
        }
    }

    public void addListener(ConsumerAdvisoryEventListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ConsumerAdvisoryEventListener l) {
        this.listeners.remove(l);
    }

    public boolean isActive(Destination destination) {
        return this.activeSubscribers.containsKey(destination);
    }

    public Set activeConsumers(Destination destination) {
        Set set = (Set)this.activeSubscribers.get(destination);
        return set != null ? set : new CopyOnWriteArraySet();
    }

    public void onMessage(Message msg) {
        if (msg instanceof ObjectMessage) {
            try {
                ConsumerInfo info = (ConsumerInfo)((ObjectMessage)msg).getObject();
                this.updateActiveConsumers(info);
                ConsumerAdvisoryEvent event = new ConsumerAdvisoryEvent(info);
                this.fireEvent(event);
            }
            catch (JMSException e) {
                log.error((Object)("Failed to process message: " + msg));
            }
        }
    }

    private void fireEvent(ConsumerAdvisoryEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ConsumerAdvisoryEventListener l = (ConsumerAdvisoryEventListener)i.next();
            l.onEvent(event);
        }
    }

    private void updateActiveConsumers(ConsumerInfo info) {
        Set set = (Set)this.activeSubscribers.get(info.getDestination());
        if (info.isStarted()) {
            if (set == null) {
                set = new CopyOnWriteArraySet();
                this.activeSubscribers.put(info.getDestination(), set);
            }
            set.add(info);
        } else if (set != null) {
            set.remove(info);
            if (set.isEmpty()) {
                this.activeSubscribers.remove(info.getDestination());
            }
        }
    }
}

