/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.io.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import org.activeio.Packet;
import org.activeio.PacketData;
import org.activeio.adapter.PacketByteArrayOutputStream;
import org.activeio.adapter.PacketInputStream;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.AbstractDefaultWireFormat;
import org.activemq.io.impl.DefaultWireFormat;
import org.activemq.io.impl.PacketReader;
import org.activemq.io.impl.PacketWriter;
import org.activemq.message.CachedValue;

public class StatelessDefaultWireFormat
extends AbstractDefaultWireFormat {
    private static final long serialVersionUID = -2648674156081593006L;

    public org.activemq.message.Packet writePacket(org.activemq.message.Packet packet, DataOutput dataOut) throws IOException {
        PacketWriter writer = this.getWriter(packet);
        if (writer != null) {
            PacketByteArrayOutputStream internalBytesOut = new PacketByteArrayOutputStream(50 + (packet.getMemoryUsage() == 0 ? 1024 : packet.getMemoryUsage()));
            DataOutputStream internalDataOut = new DataOutputStream((OutputStream)internalBytesOut);
            writer.writePacket(packet, internalDataOut);
            internalDataOut.close();
            Packet p = internalBytesOut.getPacket();
            int count = p.remaining();
            dataOut.writeByte(packet.getPacketType());
            dataOut.writeInt(count);
            packet.setMemoryUsage(count);
            p.writeTo(dataOut);
        }
        return null;
    }

    public Packet writePacket(org.activemq.message.Packet packet, PacketByteArrayOutputStream paos) throws IOException {
        PacketWriter writer = this.getWriter(packet);
        if (writer != null) {
            int startPosition = paos.position();
            paos.skip(5);
            DataOutputStream data = new DataOutputStream((OutputStream)paos);
            writer.writePacket(packet, data);
            data.close();
            Packet rc = paos.getPacket();
            int count = rc.remaining() - (startPosition + 5);
            packet.setMemoryUsage(count);
            rc.position(startPosition);
            PacketData pd = new PacketData(rc);
            pd.writeByte(packet.getPacketType());
            pd.writeInt(count);
            rc.rewind();
            return rc;
        }
        return null;
    }

    public byte[] toBytes(org.activemq.message.Packet packet) throws IOException {
        byte[] data = null;
        PacketWriter writer = this.getWriter(packet);
        if (writer != null) {
            ByteArrayOutputStream internalBytesOut = new ByteArrayOutputStream(50 + (packet.getMemoryUsage() == 0 ? 1024 : packet.getMemoryUsage()));
            DataOutputStream internalDataOut = new DataOutputStream(internalBytesOut);
            internalBytesOut.reset();
            internalDataOut.writeByte(packet.getPacketType());
            internalDataOut.writeInt(-1);
            writer.writePacket(packet, internalDataOut);
            internalDataOut.flush();
            data = internalBytesOut.toByteArray();
            int length = data.length - 5;
            packet.setMemoryUsage(length);
            data[1] = (byte)(length >>> 24 & 0xFF);
            data[2] = (byte)(length >>> 16 & 0xFF);
            data[3] = (byte)(length >>> 8 & 0xFF);
            data[4] = (byte)(length >>> 0 & 0xFF);
        }
        return data;
    }

    protected org.activemq.message.Packet readPacket(DataInput dataIn, PacketReader reader) throws IOException {
        org.activemq.message.Packet packet = reader.createPacket();
        int length = dataIn.readInt();
        packet.setMemoryUsage(length);
        reader.buildPacket(packet, dataIn);
        return packet;
    }

    public org.activemq.message.Packet readPacket(Packet dataIn) throws IOException {
        return this.readPacket(new DataInputStream((InputStream)new PacketInputStream(dataIn)));
    }

    protected void handleCachedValue(CachedValue cv) {
        throw new IllegalStateException("Value caching is not supported.");
    }

    public Object getValueFromReadCache(short key) {
        throw new IllegalStateException("Value caching is not supported.");
    }

    short getWriteCachedKey(Object value) {
        throw new IllegalStateException("Value caching is not supported.");
    }

    public boolean isCachingEnabled() {
        return false;
    }

    public WireFormat copy() {
        return new StatelessDefaultWireFormat();
    }

    private Object readResolve() throws ObjectStreamException {
        return new DefaultWireFormat();
    }
}

