/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import javax.jms.JMSException;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageContainerAdmin;
import org.activemq.service.MessageIdentity;
import org.activemq.service.Subscription;
import org.activemq.service.TopicMessageContainer;
import org.activemq.store.RecoveryListener;
import org.activemq.store.TopicMessageStore;

public class DurableTopicMessageContainer
implements TopicMessageContainer,
MessageContainerAdmin {
    private TopicMessageStore messageStore;
    private String destinationName;
    private MessageIdentity lastMessageIdentity;

    public DurableTopicMessageContainer(TopicMessageStore messageStore, String destinationName) {
        this.messageStore = messageStore;
        this.destinationName = destinationName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void addMessage(ActiveMQMessage message) throws JMSException {
        this.messageStore.addMessage(message);
        this.lastMessageIdentity = message.getJMSMessageIdentity();
    }

    public void delete(MessageIdentity messageID, MessageAck ack) throws JMSException {
    }

    public boolean containsMessage(MessageIdentity messageIdentity) throws JMSException {
        return this.getMessage(messageIdentity) != null;
    }

    public ActiveMQMessage getMessage(MessageIdentity messageID) throws JMSException {
        return this.messageStore.getMessage(messageID);
    }

    public void registerMessageInterest(MessageIdentity messageIdentity) throws JMSException {
        this.messageStore.incrementMessageCount(messageIdentity);
    }

    public void unregisterMessageInterest(MessageIdentity ack) throws JMSException {
        this.messageStore.decrementMessageCountAndMaybeDelete(ack);
    }

    public void setLastAcknowledgedMessageID(Subscription subscription, MessageIdentity messageIdentity) throws JMSException {
        this.messageStore.setLastAcknowledgedMessageIdentity(subscription.getPersistentKey(), messageIdentity);
    }

    public void recoverSubscription(final Subscription subscription) throws JMSException {
        this.messageStore.recoverSubscription(subscription.getPersistentKey(), this.lastMessageIdentity, new RecoveryListener(){

            public void recoverMessage(MessageIdentity messageIdentity) throws JMSException {
                subscription.addMessage(DurableTopicMessageContainer.this, DurableTopicMessageContainer.this.getMessage(messageIdentity));
            }
        });
    }

    public void storeSubscription(ConsumerInfo info, Subscription subscription) throws JMSException {
        this.messageStore.setSubscriberEntry(info, subscription.getSubscriptionEntry());
    }

    public void start() throws JMSException {
        this.lastMessageIdentity = this.messageStore.getLastestMessageIdentity();
        this.messageStore.start();
    }

    public void stop() throws JMSException {
        this.messageStore.stop();
    }

    public MessageContainerAdmin getMessageContainerAdmin() {
        return this;
    }

    public void empty() throws JMSException {
        this.messageStore.removeAllMessages();
    }

    public boolean isDeadLetterQueue() {
        return false;
    }

    public void deleteSubscription(String sub) throws JMSException {
        this.messageStore.deleteSubscription(sub);
    }
}

