/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Topic;
import org.activemq.DuplicateDurableSubscriptionException;
import org.activemq.broker.BrokerClient;
import org.activemq.filter.AndFilter;
import org.activemq.filter.DestinationMap;
import org.activemq.filter.Filter;
import org.activemq.filter.FilterFactory;
import org.activemq.filter.FilterFactoryImpl;
import org.activemq.filter.NoLocalFilter;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.MessageAck;
import org.activemq.service.DeadLetterPolicy;
import org.activemq.service.Dispatcher;
import org.activemq.service.MessageContainer;
import org.activemq.service.RedeliveryPolicy;
import org.activemq.service.Subscription;
import org.activemq.service.SubscriptionContainer;
import org.activemq.service.TopicMessageContainer;
import org.activemq.service.TransactionManager;
import org.activemq.service.TransactionTask;
import org.activemq.service.impl.DispatcherImpl;
import org.activemq.service.impl.DurableTopicMessageContainer;
import org.activemq.service.impl.DurableTopicSubscriptionContainerImpl;
import org.activemq.service.impl.MessageContainerManagerSupport;
import org.activemq.store.PersistenceAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DurableTopicMessageContainerManager
extends MessageContainerManagerSupport {
    private static final Log log = LogFactory.getLog((Class)DurableTopicMessageContainerManager.class);
    private PersistenceAdapter persistenceAdapter;
    protected SubscriptionContainer subscriptionContainer;
    protected FilterFactory filterFactory;
    protected Map activeSubscriptions = new ConcurrentHashMap();
    private DestinationMap destinationMap = new DestinationMap();
    private ConcurrentHashMap durableSubscriptions = new ConcurrentHashMap();

    public DurableTopicMessageContainerManager(PersistenceAdapter persistenceAdapter, RedeliveryPolicy redeliveryPolicy, DeadLetterPolicy deadLetterPolicy) {
        this(persistenceAdapter, new DurableTopicSubscriptionContainerImpl(redeliveryPolicy, deadLetterPolicy), new FilterFactoryImpl(), new DispatcherImpl());
    }

    public DurableTopicMessageContainerManager(PersistenceAdapter persistenceAdapter, SubscriptionContainer subscriptionContainer, FilterFactory filterFactory, Dispatcher dispatcher) {
        super(dispatcher);
        this.persistenceAdapter = persistenceAdapter;
        this.subscriptionContainer = subscriptionContainer;
        this.filterFactory = filterFactory;
        try {
            this.loadAllMessageContainers();
        }
        catch (JMSException e) {
            log.error((Object)"Failed to load initial Topic Containers", (Throwable)e);
        }
    }

    public void addMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        if (info.isDurableTopic()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding consumer: " + info));
            }
            this.doAddMessageConsumer(client, info);
        }
    }

    public void removeMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        Subscription sub = (Subscription)this.activeSubscriptions.remove(info.getConsumerId());
        if (sub != null) {
            sub.setActive(false);
            this.dispatcher.removeActiveSubscription(client, sub);
        }
    }

    public void deleteSubscription(String clientId, String subscriberName) throws JMSException {
        String consumerKey = ConsumerInfo.generateConsumerKey(clientId, subscriberName);
        Subscription sub = (Subscription)this.durableSubscriptions.remove((Object)consumerKey);
        if (sub != null) {
            if (sub.isActive()) {
                throw new JMSException("The Consummer " + subscriberName + " is still active");
            }
            this.subscriptionContainer.removeSubscription(sub.getConsumerId());
            sub.clear();
            Set containers = this.destinationMap.get(sub.getDestination());
            Iterator iter = containers.iterator();
            while (iter.hasNext()) {
                TopicMessageContainer container = (TopicMessageContainer)iter.next();
                if (!(container instanceof DurableTopicMessageContainer)) continue;
                ((DurableTopicMessageContainer)container).deleteSubscription(sub.getPersistentKey());
            }
        } else {
            throw new InvalidDestinationException("The Consumer " + subscriberName + " does not exist for client: " + clientId);
        }
    }

    public void sendMessage(final BrokerClient client, final ActiveMQMessage message) throws JMSException {
        ActiveMQDestination dest = (ActiveMQDestination)message.getJMSDestination();
        if (dest != null && dest.isTopic() && message.getJMSDeliveryMode() == 2) {
            final MessageContainer container = this.getContainer(dest.getPhysicalName());
            container.addMessage(message);
            TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

                public void execute() throws Throwable {
                    DurableTopicMessageContainerManager.this.doSendMessage(client, message, container);
                }
            });
        }
    }

    private void doSendMessage(BrokerClient client, ActiveMQMessage message, MessageContainer container) throws JMSException {
        Set matchingSubscriptions = this.subscriptionContainer.getSubscriptions(message.getJMSActiveMQDestination());
        if (!matchingSubscriptions.isEmpty()) {
            Iterator i = matchingSubscriptions.iterator();
            while (i.hasNext()) {
                Subscription sub = (Subscription)i.next();
                if (!sub.isTarget(message)) continue;
                sub.addMessage(container, message);
            }
            this.updateSendStats(client, message);
        }
    }

    public Map getLocalDestinations() {
        HashMap<String, ActiveMQDestination> localDestinations = new HashMap<String, ActiveMQDestination>();
        Iterator iter = this.subscriptionContainer.subscriptionIterator();
        while (iter.hasNext()) {
            Subscription sub = (Subscription)iter.next();
            if (!sub.isLocalSubscription()) continue;
            ActiveMQDestination dest = sub.getDestination();
            localDestinations.put(dest.getPhysicalName(), dest);
        }
        return Collections.unmodifiableMap(localDestinations);
    }

    public void acknowledgeMessage(BrokerClient client, MessageAck ack) throws JMSException {
        if (!ack.getDestination().isTopic() || !ack.isPersistent()) {
            return;
        }
        Subscription sub = (Subscription)this.activeSubscriptions.get(ack.getConsumerId());
        if (sub == null) {
            return;
        }
        sub.messageConsumed(ack);
    }

    public void poll() throws JMSException {
    }

    protected MessageContainer createContainer(String destinationName) throws JMSException {
        DurableTopicMessageContainer topicMessageContainer = new DurableTopicMessageContainer(this.persistenceAdapter.createTopicMessageStore(destinationName), destinationName);
        this.destinationMap.put(new ActiveMQTopic(destinationName), topicMessageContainer);
        return topicMessageContainer;
    }

    protected Destination createDestination(String destinationName) {
        return new ActiveMQTopic(destinationName);
    }

    protected void doAddMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        Subscription subscription;
        boolean shouldRecover = false;
        if (info.getConsumerName() != null && info.getClientId() != null) {
            Iterator iter = this.activeSubscriptions.values().iterator();
            while (iter.hasNext()) {
                Subscription subscription2 = (Subscription)iter.next();
                if (!subscription2.isSameDurableSubscription(info)) continue;
                throw new DuplicateDurableSubscriptionException(info);
            }
        }
        if ((subscription = (Subscription)this.durableSubscriptions.get((Object)info.getConsumerKey())) != null) {
            if (!this.equal(subscription.getDestination(), info.getDestination()) || !this.equal(subscription.getSelector(), info.getSelector())) {
                this.subscriptionContainer.removeSubscription(info.getConsumerId());
                subscription.clear();
                subscription = this.subscriptionContainer.makeSubscription(this.dispatcher, client, info, this.createFilter(info));
                this.durableSubscriptions.put((Object)info.getConsumerKey(), (Object)subscription);
            }
        } else {
            subscription = this.subscriptionContainer.makeSubscription(this.dispatcher, client, info, this.createFilter(info));
            shouldRecover = true;
            this.durableSubscriptions.put((Object)info.getConsumerKey(), (Object)subscription);
        }
        subscription.setActiveConsumer(client, info);
        this.activeSubscriptions.put(info.getConsumerId(), subscription);
        this.dispatcher.addActiveSubscription(client, subscription);
        this.getContainer(subscription.getDestination().getPhysicalName());
        Set containers = this.destinationMap.get(subscription.getDestination());
        Iterator iter = containers.iterator();
        while (iter.hasNext()) {
            TopicMessageContainer container = (TopicMessageContainer)iter.next();
            if (!(container instanceof DurableTopicMessageContainer)) continue;
            ((DurableTopicMessageContainer)container).storeSubscription(info, subscription);
        }
        if (shouldRecover) {
            this.recoverSubscriptions(subscription);
        }
        subscription.setActive(true);
    }

    protected final boolean equal(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    protected void recoverSubscriptions(Subscription subscription) throws JMSException {
        this.getContainer(subscription.getDestination().getPhysicalName());
        Set containers = this.destinationMap.get(subscription.getDestination());
        Iterator iter = containers.iterator();
        while (iter.hasNext()) {
            TopicMessageContainer container = (TopicMessageContainer)iter.next();
            container.recoverSubscription(subscription);
        }
    }

    protected void loadAllMessageContainers() throws JMSException {
        Map destinations = this.persistenceAdapter.getInitialDestinations();
        if (destinations != null) {
            Iterator iter = destinations.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Destination destination = (Destination)entry.getValue();
                if (!(destination instanceof Topic)) continue;
                this.loadContainer(name, destination);
            }
        }
    }

    protected Filter createFilter(ConsumerInfo info) throws JMSException {
        Filter filter = this.filterFactory.createFilter(info.getDestination(), info.getSelector());
        if (info.isNoLocal()) {
            filter = new AndFilter(filter, new NoLocalFilter(info.getClientId()));
        }
        return filter;
    }

    public void createMessageContainer(ActiveMQDestination dest) throws JMSException {
        if (!dest.isTopic()) {
            return;
        }
        super.createMessageContainer(dest);
    }

    public synchronized void destroyMessageContainer(ActiveMQDestination dest) throws JMSException {
        if (!dest.isTopic()) {
            return;
        }
        super.destroyMessageContainer(dest);
        this.destinationMap.removeAll(dest);
    }
}

