/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.reliable;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.composite.CompositeTransportChannelFactory;
import org.activemq.transport.reliable.KeepAliveDaemon;
import org.activemq.transport.reliable.ReliableTransportChannel;
import org.activemq.transport.reliable.SMLCGRandom;
import org.activemq.util.JMSExceptionHelper;

public class ReliableTransportChannelFactory
extends CompositeTransportChannelFactory {
    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        try {
            List uris = new ArrayList();
            String text = ReliableTransportChannelFactory.parseURIs(uris, remoteLocation);
            uris = this.randomizeURIs(uris);
            ReliableTransportChannel channel = new ReliableTransportChannel(wireFormat, uris);
            channel = (ReliableTransportChannel)this.populateProperties((TransportChannel)channel, text);
            KeepAliveDaemon daemon = KeepAliveDaemon.getInstance();
            daemon.addMonitoredChannel(channel);
            daemon.start();
            return channel;
        }
        catch (URISyntaxException e) {
            throw JMSExceptionHelper.newJMSException("Can't parse list of URIs for: " + remoteLocation + ". Reason: " + e, e);
        }
    }

    protected List randomizeURIs(List uris) {
        if (!uris.isEmpty()) {
            int i;
            int size = uris.size();
            Object[] result = new Object[size];
            SMLCGRandom random = new SMLCGRandom();
            int startIndex = (int)(random.nextDouble() * (double)(size + 1));
            int count = 0;
            for (i = startIndex; i < size; ++i) {
                result[count++] = uris.get(i);
            }
            for (i = 0; i < startIndex; ++i) {
                result[count++] = uris.get(i);
            }
            return new ArrayList<Object>(Arrays.asList(result));
        }
        return uris;
    }
}

