/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.activemq.broker.BrokerClient;
import org.activemq.broker.BrokerConnector;
import org.activemq.broker.BrokerContainer;
import org.activemq.broker.impl.BrokerClientImpl;
import org.activemq.io.WireFormat;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQXid;
import org.activemq.message.BrokerInfo;
import org.activemq.message.ConnectionInfo;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.DurableUnsubscribe;
import org.activemq.message.MessageAck;
import org.activemq.message.ProducerInfo;
import org.activemq.message.SessionInfo;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.TransportChannelListener;
import org.activemq.transport.TransportServerChannel;
import org.activemq.transport.TransportServerChannelProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrokerConnectorImpl
implements BrokerConnector,
TransportChannelListener {
    private BrokerInfo brokerInfo;
    private TransportServerChannel serverChannel;
    private Log log;
    private BrokerContainer container;
    private Map clients = Collections.synchronizedMap(new HashMap());
    static final /* synthetic */ boolean $assertionsDisabled;

    public BrokerConnectorImpl(BrokerContainer container, String bindAddress, WireFormat wireFormat) throws JMSException {
        this(container, BrokerConnectorImpl.createTransportServerChannel(wireFormat, bindAddress));
    }

    public BrokerConnectorImpl(BrokerContainer container, TransportServerChannel serverChannel) {
        if (!$assertionsDisabled && container == null) {
            throw new AssertionError();
        }
        this.brokerInfo = new BrokerInfo();
        this.brokerInfo.setBrokerName(container.getBroker().getBrokerName());
        this.brokerInfo.setClusterName(container.getBroker().getBrokerClusterName());
        this.log = LogFactory.getLog((String)this.getClass().getName());
        this.serverChannel = serverChannel;
        this.container = container;
        this.container.addConnector(this);
        serverChannel.setTransportChannelListener(this);
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public int getBrokerCapacity() {
        return this.container.getBroker().getRoundedCapacity();
    }

    public TransportServerChannel getServerChannel() {
        return this.serverChannel;
    }

    public void start() throws JMSException {
        this.serverChannel.start();
        this.log.info((Object)("ActiveMQ connector started: " + this.serverChannel));
    }

    public void stop() throws JMSException {
        this.container.removeConnector(this);
        this.serverChannel.stop();
        this.log.info((Object)("ActiveMQ connector stopped: " + this.serverChannel));
    }

    public void registerClient(BrokerClient client, ConnectionInfo info) throws JMSException {
        this.container.registerConnection(client, info);
    }

    public void deregisterClient(BrokerClient client, ConnectionInfo info) throws JMSException {
        this.container.deregisterConnection(client, info);
    }

    public void registerMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        if (info.getDestination() == null) {
            throw new JMSException("No Destination specified on consumerInfo for client: " + client + " info: " + info);
        }
        this.container.registerMessageConsumer(client, info);
    }

    public void deregisterMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        this.container.deregisterMessageConsumer(client, info);
    }

    public void registerMessageProducer(BrokerClient client, ProducerInfo info) throws JMSException {
        this.container.registerMessageProducer(client, info);
    }

    public void deregisterMessageProducer(BrokerClient client, ProducerInfo info) throws JMSException {
        this.container.deregisterMessageProducer(client, info);
    }

    public void registerSession(BrokerClient client, SessionInfo info) throws JMSException {
        this.container.registerSession(client, info);
    }

    public void deregisterSession(BrokerClient client, SessionInfo info) throws JMSException {
        this.container.deregisterSession(client, info);
    }

    public void startTransaction(BrokerClient client, String transactionId) throws JMSException {
        this.container.startTransaction(client, transactionId);
    }

    public void rollbackTransaction(BrokerClient client, String transactionId) throws JMSException {
        this.container.rollbackTransaction(client, transactionId);
    }

    public void commitTransaction(BrokerClient client, String transactionId) throws JMSException {
        this.container.commitTransaction(client, transactionId);
    }

    public void sendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        this.container.sendMessage(client, message);
    }

    public void acknowledgeMessage(BrokerClient client, MessageAck ack) throws JMSException {
        this.container.acknowledgeMessage(client, ack);
    }

    public void durableUnsubscribe(BrokerClient client, DurableUnsubscribe ds) throws JMSException {
        this.container.durableUnsubscribe(client, ds);
    }

    public void addClient(TransportChannel channel) {
        try {
            BrokerClientImpl client = new BrokerClientImpl();
            client.initialize(this, channel);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Starting new client: " + client));
            }
            channel.setServerSide(true);
            channel.start();
            this.clients.put(channel, client);
        }
        catch (JMSException e) {
            this.log.error((Object)("Failed to add client due to: " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void removeClient(TransportChannel channel) {
        BrokerClient client = (BrokerClient)this.clients.remove(channel);
        if (client != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Client leaving client: " + client));
            }
            client.cleanUp();
        } else {
            this.log.warn((Object)("No such client for channel: " + channel));
        }
    }

    public BrokerContainer getBrokerContainer() {
        return this.container;
    }

    public void startTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        this.container.startTransaction(client, xid);
    }

    public ActiveMQXid[] getPreparedTransactions(BrokerClient client) throws XAException {
        return this.container.getPreparedTransactions(client);
    }

    public int prepareTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        return this.container.prepareTransaction(client, xid);
    }

    public void rollbackTransaction(BrokerClient client, ActiveMQXid xid) throws XAException {
        this.container.rollbackTransaction(client, xid);
    }

    public void commitTransaction(BrokerClient client, ActiveMQXid xid, boolean onePhase) throws XAException {
        this.container.commitTransaction(client, xid, onePhase);
    }

    public String getResourceManagerId(BrokerClient client) {
        return this.getBrokerInfo().getBrokerName();
    }

    protected static TransportServerChannel createTransportServerChannel(WireFormat wireFormat, String bindAddress) throws JMSException {
        URI url;
        try {
            url = new URI(bindAddress);
        }
        catch (URISyntaxException e) {
            JMSException jmsEx = new JMSException("Badly formated bindAddress: " + e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        return TransportServerChannelProvider.create(wireFormat, url);
    }

    static {
        $assertionsDisabled = !BrokerConnectorImpl.class.desiredAssertionStatus();
    }
}

