/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.boundedvm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.activemq.broker.BrokerClient;
import org.activemq.filter.AndFilter;
import org.activemq.filter.DestinationMap;
import org.activemq.filter.Filter;
import org.activemq.filter.FilterFactory;
import org.activemq.filter.FilterFactoryImpl;
import org.activemq.filter.NoLocalFilter;
import org.activemq.io.util.MemoryBoundedQueue;
import org.activemq.io.util.MemoryBoundedQueueManager;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.MessageAck;
import org.activemq.service.DeadLetterPolicy;
import org.activemq.service.MessageContainer;
import org.activemq.service.MessageContainerManager;
import org.activemq.service.RedeliveryPolicy;
import org.activemq.service.TransactionManager;
import org.activemq.service.TransactionTask;
import org.activemq.service.boundedvm.TransientQueueBoundedMessageContainer;
import org.activemq.service.boundedvm.TransientQueueSubscription;
import org.activemq.service.boundedvm.TransientSubscription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransientQueueBoundedMessageManager
implements MessageContainerManager,
Runnable {
    private static final int DEFAULT_GARBAGE_COLLECTION_CAPACITY_LIMIT = 10;
    private static final long DEFAULT_INACTIVE_TIMEOUT = 30000L;
    private static final Log log = LogFactory.getLog((Class)TransientQueueBoundedMessageManager.class);
    private MemoryBoundedQueueManager queueManager;
    private ConcurrentHashMap containers;
    private ConcurrentHashMap subscriptions;
    private FilterFactory filterFactory;
    private SynchronizedBoolean started;
    private SynchronizedBoolean doingGarbageCollection;
    private Map destinations;
    private DestinationMap destinationMap;
    private PooledExecutor threadPool;
    private long inactiveTimeout;
    private int garbageCoolectionCapacityLimit;
    private RedeliveryPolicy redeliveryPolicy;
    private DeadLetterPolicy deadLetterPolicy;

    public TransientQueueBoundedMessageManager(MemoryBoundedQueueManager mgr, RedeliveryPolicy redeliveryPolicy, DeadLetterPolicy deadLetterPolicy) {
        this.queueManager = mgr;
        this.redeliveryPolicy = redeliveryPolicy;
        this.deadLetterPolicy = deadLetterPolicy;
        this.containers = new ConcurrentHashMap();
        this.destinationMap = new DestinationMap();
        this.destinations = new ConcurrentHashMap();
        this.subscriptions = new ConcurrentHashMap();
        this.filterFactory = new FilterFactoryImpl();
        this.started = new SynchronizedBoolean(false);
        this.doingGarbageCollection = new SynchronizedBoolean(false);
        this.threadPool = new PooledExecutor();
        this.threadPool.setThreadFactory((ThreadFactory)new TransientQueueThreadFactory());
        this.inactiveTimeout = 30000L;
        this.garbageCoolectionCapacityLimit = 10;
    }

    public int getGarbageCoolectionCapacityLimit() {
        return this.garbageCoolectionCapacityLimit;
    }

    public void setGarbageCoolectionCapacityLimit(int garbageCoolectionCapacityLimit) {
        this.garbageCoolectionCapacityLimit = garbageCoolectionCapacityLimit;
    }

    public long getInactiveTimeout() {
        return this.inactiveTimeout;
    }

    public void setInactiveTimeout(long inactiveTimeout) {
        this.inactiveTimeout = inactiveTimeout;
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            Iterator i = this.containers.values().iterator();
            while (i.hasNext()) {
                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                container.start();
            }
            try {
                this.threadPool.execute((Runnable)this);
            }
            catch (InterruptedException e) {
                JMSException jmsEx = new JMSException("Garbage collection interupted on start()");
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false)) {
            Iterator i = this.containers.values().iterator();
            while (i.hasNext()) {
                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                container.stop();
            }
            this.threadPool.interruptAll();
            this.threadPool.shutdownNow();
        }
    }

    public void run() {
        while (this.started.get()) {
            this.doGarbageCollection();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void addMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        ActiveMQDestination destination = info.getDestination();
        if (destination.isQueue()) {
            String name;
            TransientQueueSubscription ts;
            TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)this.containers.get((Object)destination);
            if (container == null) {
                MemoryBoundedQueue queue = this.queueManager.getMemoryBoundedQueue(client.toString());
                container = new TransientQueueBoundedMessageContainer((Executor)this.threadPool, this.queueManager, destination, this.redeliveryPolicy, this.deadLetterPolicy);
                this.addContainer(container);
                if (this.started.get()) {
                    container.start();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding consumer: " + info));
            }
            if ((ts = container.addConsumer(this.createFilter(info), info, client)) != null) {
                this.subscriptions.put((Object)info.getConsumerId(), (Object)ts);
            }
            if (!this.destinations.containsKey(name = destination.getPhysicalName())) {
                this.destinations.put(name, destination);
            }
        }
    }

    public synchronized void removeMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        ActiveMQDestination destination = info.getDestination();
        if (destination.isQueue()) {
            Iterator i = this.containers.values().iterator();
            while (i.hasNext()) {
                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                if (container == null) continue;
                container.removeConsumer(info);
            }
            this.subscriptions.remove((Object)info.getConsumerId());
        }
    }

    public void deleteSubscription(String clientId, String subscriberName) throws JMSException {
    }

    public void sendMessage(final BrokerClient client, final ActiveMQMessage message) throws JMSException {
        ActiveMQDestination destination = message.getJMSActiveMQDestination();
        if (!destination.isQueue() || !message.isTemporary()) {
            return;
        }
        TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

            public void execute() throws Throwable {
                TransientQueueBoundedMessageManager.this.doSendMessage(client, message);
            }
        });
    }

    private void doSendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        TransientQueueBoundedMessageContainer container;
        ActiveMQDestination destination = message.getJMSActiveMQDestination();
        if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
            this.doGarbageCollection();
        }
        if ((container = (TransientQueueBoundedMessageContainer)this.containers.get((Object)destination)) == null) {
            MemoryBoundedQueue queue = this.queueManager.getMemoryBoundedQueue(client.toString());
            container = new TransientQueueBoundedMessageContainer((Executor)this.threadPool, this.queueManager, destination, this.redeliveryPolicy, this.deadLetterPolicy);
            this.addContainer(container);
            if (this.started.get()) {
                container.start();
            }
        }
        Set set = this.destinationMap.get(message.getJMSActiveMQDestination());
        Iterator i = set.iterator();
        while (i.hasNext()) {
            container = (TransientQueueBoundedMessageContainer)i.next();
            container.enqueue(message);
        }
    }

    public void acknowledgeMessage(BrokerClient client, final MessageAck ack) throws JMSException {
        if (!ack.getDestination().isQueue() || !ack.isTemporary()) {
            return;
        }
        final TransientQueueSubscription ts = (TransientQueueSubscription)this.subscriptions.get((Object)ack.getConsumerId());
        if (ts == null) {
            return;
        }
        ActiveMQMessage message = ts.acknowledgeMessage(ack.getMessageID());
        if (message == null) {
            return;
        }
        if (ts.isBrowser()) {
            ts.addAckedMessage(message);
            return;
        }
        if (!ack.isMessageRead() || ack.isExpired()) {
            this.redeliverMessage(ts, ack, message);
        } else if (TransactionManager.isCurrentTransaction()) {
            if (!ts.hasAckedMessage()) {
                TransactionManager.getContexTransaction().addPostRollbackTask(new TransactionTask(){

                    public void execute() throws Throwable {
                        List ackList = ts.listAckedMessages();
                        HashMap<TransientQueueBoundedMessageContainer, LinkedList<ActiveMQMessage>> redeliverMap = new HashMap<TransientQueueBoundedMessageContainer, LinkedList<ActiveMQMessage>>();
                        Iterator iter = ackList.iterator();
                        while (iter.hasNext()) {
                            ActiveMQMessage message = (ActiveMQMessage)iter.next();
                            message.setJMSRedelivered(true);
                            if (message.incrementDeliveryCount() >= TransientQueueBoundedMessageManager.this.redeliveryPolicy.getMaximumRetryCount()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Message: " + message + " has exceeded its retry count"));
                                }
                                TransientQueueBoundedMessageManager.this.deadLetterPolicy.sendToDeadLetter(message);
                                continue;
                            }
                            if (ack.isExpired()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Message: " + message + " has expired"));
                                }
                                TransientQueueBoundedMessageManager.this.deadLetterPolicy.sendToDeadLetter(message);
                                continue;
                            }
                            Set containers = TransientQueueBoundedMessageManager.this.destinationMap.get(message.getJMSActiveMQDestination());
                            Iterator i = containers.iterator();
                            while (i.hasNext()) {
                                TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                                LinkedList<ActiveMQMessage> l = (LinkedList<ActiveMQMessage>)redeliverMap.get(container);
                                if (l == null) {
                                    l = new LinkedList<ActiveMQMessage>();
                                    redeliverMap.put(container, l);
                                }
                                l.add(message);
                            }
                        }
                        Iterator i = redeliverMap.keySet().iterator();
                        while (i.hasNext()) {
                            TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
                            List l = (List)redeliverMap.get(container);
                            container.redeliver(l);
                        }
                        ts.removeAllAckedMessages();
                    }
                });
                TransactionManager.getContexTransaction().addPostCommitTask(new TransactionTask(){

                    public void execute() throws Throwable {
                        ts.removeAllAckedMessages();
                    }
                });
            }
            ts.addAckedMessage(message);
        }
    }

    private void redeliverMessage(TransientQueueSubscription ts, MessageAck ack, ActiveMQMessage message) throws JMSException {
        block3: {
            block4: {
                block2: {
                    message.setJMSRedelivered(true);
                    if (message.incrementDeliveryCount() < this.redeliveryPolicy.getMaximumRetryCount()) break block2;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Message: " + message + " has exceeded its retry count"));
                    }
                    this.deadLetterPolicy.sendToDeadLetter(message);
                    break block3;
                }
                if (!ack.isExpired()) break block4;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message: " + message + " has expired"));
                }
                this.deadLetterPolicy.sendToDeadLetter(message);
                break block3;
            }
            Set set = this.destinationMap.get(message.getJMSActiveMQDestination());
            Iterator i = set.iterator();
            if (!i.hasNext()) break block3;
            TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)i.next();
            container.redeliver(message);
        }
    }

    public void poll() throws JMSException {
    }

    public MessageContainer getContainer(String physicalName) throws JMSException {
        Object key = this.destinations.get(physicalName);
        if (key != null) {
            return (MessageContainer)this.containers.get(key);
        }
        return null;
    }

    public Map getDestinations() {
        return Collections.unmodifiableMap(this.destinations);
    }

    public Map getLocalDestinations() {
        HashMap<String, ActiveMQDestination> localDestinations = new HashMap<String, ActiveMQDestination>();
        Iterator iter = this.subscriptions.values().iterator();
        while (iter.hasNext()) {
            TransientSubscription sub = (TransientSubscription)iter.next();
            if (!sub.isLocalSubscription()) continue;
            ActiveMQDestination dest = sub.getDestination();
            localDestinations.put(dest.getPhysicalName(), dest);
        }
        return Collections.unmodifiableMap(localDestinations);
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy policy) {
        this.deadLetterPolicy = policy;
    }

    protected Filter createFilter(ConsumerInfo info) throws JMSException {
        Filter filter = this.filterFactory.createFilter(info.getDestination(), info.getSelector());
        if (info.isNoLocal()) {
            filter = new AndFilter(filter, new NoLocalFilter(info.getClientId()));
        }
        return filter;
    }

    private void doGarbageCollection() {
        if (this.doingGarbageCollection.commit(false, true)) {
            TransientQueueBoundedMessageContainer container;
            Iterator i;
            if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
                i = this.containers.values().iterator();
                while (i.hasNext()) {
                    container = (TransientQueueBoundedMessageContainer)i.next();
                    container.removeExpiredMessages();
                    log.warn((Object)("memory limit low - forced to remove expired messages: " + container.getDestinationName()));
                }
            }
            if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
                i = this.containers.values().iterator();
                while (i.hasNext()) {
                    container = (TransientQueueBoundedMessageContainer)i.next();
                    if (container.isActive() || container.getIdleTimestamp() >= System.currentTimeMillis() - this.inactiveTimeout) continue;
                    this.removeContainer(container);
                    log.warn((Object)("memory limit low - forced to remove inactive and idle queue: " + container.getDestinationName()));
                }
            }
            if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
                i = this.containers.values().iterator();
                while (i.hasNext()) {
                    container = (TransientQueueBoundedMessageContainer)i.next();
                    if (container.isActive() || !container.getDestination().isTemporary()) continue;
                    this.removeContainer(container);
                    log.warn((Object)("memory limit low - forced to remove inactive temporary queue: " + container.getDestinationName()));
                }
            }
            if (this.queueManager.getCurrentCapacity() <= this.garbageCoolectionCapacityLimit) {
                i = this.containers.values().iterator();
                while (i.hasNext()) {
                    container = (TransientQueueBoundedMessageContainer)i.next();
                    if (container.isActive() || container.isEmpty()) continue;
                    this.removeContainer(container);
                    log.warn((Object)("memory limit low - forced to remove inactive queue: " + container.getDestinationName()));
                }
            }
            this.doingGarbageCollection.set(false);
        }
    }

    private synchronized void addContainer(TransientQueueBoundedMessageContainer container) {
        this.containers.put((Object)container.getDestination(), (Object)container);
        this.destinationMap.put(container.getDestination(), container);
    }

    private synchronized void removeContainer(TransientQueueBoundedMessageContainer container) {
        try {
            container.close();
            log.info((Object)("closed inactive transient queue container: " + container.getDestinationName()));
        }
        catch (JMSException e) {
            log.warn((Object)"failure closing container", (Throwable)e);
        }
        this.containers.remove((Object)container.getDestination());
        this.destinationMap.remove(container.getDestination(), container);
    }

    protected Executor getThreadPool() {
        return this.threadPool;
    }

    public void createMessageContainer(ActiveMQDestination dest) throws JMSException {
    }

    public void destroyMessageContainer(ActiveMQDestination dest) throws JMSException {
        if (!dest.isQueue()) {
            return;
        }
        TransientQueueBoundedMessageContainer container = (TransientQueueBoundedMessageContainer)this.containers.remove((Object)dest);
        if (container != null) {
            container.stop();
        }
        this.destinationMap.removeAll(dest);
    }

    public Map getMessageContainerAdmins() throws JMSException {
        return Collections.EMPTY_MAP;
    }

    protected static class TransientQueueThreadFactory
    implements ThreadFactory {
        protected TransientQueueThreadFactory() {
        }

        public Thread newThread(Runnable command) {
            Thread result = new Thread(command);
            result.setPriority(6);
            result.setDaemon(true);
            return result;
        }
    }
}

