/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.journal;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.activeio.journal.RecordLocation;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQXid;
import org.activemq.message.MessageAck;
import org.activemq.store.TransactionStore;
import org.activemq.store.journal.JournalAck;
import org.activemq.store.journal.JournalMessageStore;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.activemq.store.journal.JournalTopicMessageStore;
import org.activemq.store.journal.TxCommand;

public class JournalTransactionStore
implements TransactionStore {
    private final JournalPersistenceAdapter peristenceAdapter;
    ConcurrentHashMap inflightTransactions = new ConcurrentHashMap();
    ConcurrentHashMap preparedTransactions = new ConcurrentHashMap();

    public JournalTransactionStore(JournalPersistenceAdapter adapter) {
        this.peristenceAdapter = adapter;
    }

    public void prepare(Object txid) throws XAException {
        Tx tx = (Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        this.peristenceAdapter.writeTxCommand(new TxCommand(1, txid, false), true);
        this.preparedTransactions.put(txid, (Object)tx);
    }

    public void replayPrepare(Object txid) throws IOException {
        Tx tx = (Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        this.preparedTransactions.put(txid, (Object)tx);
    }

    public Tx getTx(Object txid, RecordLocation location) {
        Tx tx = (Tx)this.inflightTransactions.get(txid);
        if (tx == null) {
            tx = new Tx(location);
            this.inflightTransactions.put(txid, (Object)tx);
        }
        return tx;
    }

    public void commit(Object txid, boolean wasPrepared) throws XAException {
        Tx tx = wasPrepared ? (Tx)this.preparedTransactions.remove(txid) : (Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        if (txid.getClass() == ActiveMQXid.class) {
            this.peristenceAdapter.writeTxCommand(new TxCommand(2, txid, wasPrepared), true);
        } else {
            this.peristenceAdapter.writeTxCommand(new TxCommand(4, txid, wasPrepared), true);
        }
    }

    public Tx replayCommit(Object txid, boolean wasPrepared) throws IOException {
        if (wasPrepared) {
            return (Tx)this.preparedTransactions.remove(txid);
        }
        return (Tx)this.inflightTransactions.remove(txid);
    }

    public void rollback(Object txid) throws XAException {
        Tx tx = (Tx)this.inflightTransactions.remove(txid);
        if (tx != null) {
            tx = (Tx)this.preparedTransactions.remove(txid);
        }
        if (tx != null) {
            if (txid.getClass() == ActiveMQXid.class) {
                this.peristenceAdapter.writeTxCommand(new TxCommand(3, txid, false), true);
            } else {
                this.peristenceAdapter.writeTxCommand(new TxCommand(5, txid, false), true);
            }
        }
    }

    public void replayRollback(Object txid) throws IOException {
        Tx tx = (Tx)this.inflightTransactions.remove(txid);
        if (tx != null) {
            tx = (Tx)this.preparedTransactions.remove(txid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void recover(TransactionStore.RecoveryListener listener) throws XAException {
        this.inflightTransactions.clear();
        Iterator iter = this.preparedTransactions.keySet().iterator();
        while (iter.hasNext()) {
            Object txid = iter.next();
            Tx tx = (Tx)this.preparedTransactions.get(txid);
            try {
                listener.recover((ActiveMQXid)txid, tx.getMessages(), tx.getAcks());
            }
            catch (JMSException e) {
                throw (XAException)new XAException().initCause(e);
                return;
            }
        }
    }

    void addMessage(JournalMessageStore store, ActiveMQMessage message, RecordLocation location) {
        Tx tx = this.getTx(message.getTransactionId(), location);
        tx.add(store, message);
    }

    public void removeMessage(JournalMessageStore store, MessageAck ack, RecordLocation location) {
        Tx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store, ack);
    }

    public void acknowledge(JournalTopicMessageStore store, JournalAck ack, RecordLocation location) {
        Tx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store, ack);
    }

    public RecordLocation checkpoint() throws IOException {
        RecordLocation location;
        Tx tx;
        RecordLocation rc = null;
        Iterator iter = this.inflightTransactions.values().iterator();
        while (iter.hasNext()) {
            tx = (Tx)iter.next();
            location = tx.location;
            if (rc != null && rc.compareTo((Object)location) >= 0) continue;
            rc = location;
        }
        iter = this.preparedTransactions.values().iterator();
        while (iter.hasNext()) {
            tx = (Tx)iter.next();
            location = tx.location;
            if (rc != null && rc.compareTo((Object)location) >= 0) continue;
            rc = location;
        }
        return rc;
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    public static interface RemoveMessageCommand {
        public MessageAck getMessageAck();

        public void run() throws IOException;
    }

    public static interface AddMessageCommand {
        public ActiveMQMessage getMessage();

        public void run() throws IOException;
    }

    public static class Tx {
        private final RecordLocation location;
        private ArrayList operations = new ArrayList();

        public Tx(RecordLocation location) {
            this.location = location;
        }

        public void add(JournalMessageStore store, ActiveMQMessage msg) {
            this.operations.add(new TxOperation(0, store, msg));
        }

        public void add(JournalMessageStore store, MessageAck ack) {
            this.operations.add(new TxOperation(1, store, ack));
        }

        public void add(JournalTopicMessageStore store, JournalAck ack) {
            this.operations.add(new TxOperation(3, store, ack));
        }

        public ActiveMQMessage[] getMessages() {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                TxOperation op = (TxOperation)iter.next();
                if (op.operationType != 0) continue;
                list.add(op.data);
            }
            ActiveMQMessage[] rc = new ActiveMQMessage[list.size()];
            list.toArray(rc);
            return rc;
        }

        public MessageAck[] getAcks() {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                TxOperation op = (TxOperation)iter.next();
                if (op.operationType != 1) continue;
                list.add(op.data);
            }
            MessageAck[] rc = new MessageAck[list.size()];
            list.toArray(rc);
            return rc;
        }

        public ArrayList getOperations() {
            return this.operations;
        }
    }

    public static class TxOperation {
        static final byte ADD_OPERATION_TYPE = 0;
        static final byte REMOVE_OPERATION_TYPE = 1;
        static final byte ACK_OPERATION_TYPE = 3;
        public byte operationType;
        public JournalMessageStore store;
        public Object data;

        public TxOperation(byte operationType, JournalMessageStore store, Object data) {
            this.operationType = operationType;
            this.store = store;
            this.data = data;
        }
    }
}

