/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.jabber;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.activemq.io.AbstractWireFormat;
import org.activemq.io.WireFormat;
import org.activemq.io.util.ByteArray;
import org.activemq.message.ActiveMQBytesMessage;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQObjectMessage;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.ConnectionInfo;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.Packet;
import org.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabberWireFormat
extends AbstractWireFormat {
    private static final Log log = LogFactory.getLog((Class)JabberWireFormat.class);
    private static final String NAMESPACE = "http://etherx.jabber.org/streams";
    private static final String QUEUE_PREFIX = "queue:";
    private static final String TOPIC_PREFIX = "topic:";
    private static final String TEMP_QUEUE_PREFIX = "tempQueue:";
    private static final String TEMP_TOPIC_PREFIX = "tempTopic:";
    private static final QName STREAM_QNAME = new QName("http://etherx.jabber.org/streams", "stream", "stream");
    private static final QName MESSAGE_QNAME = new QName("jabber:client", "message", "message");
    private static final QName AUTH_QNAME = new QName("jabber:iq:auth", "query", "query");
    private IdGenerator idGenerator = new IdGenerator();
    private String clientID = this.idGenerator.generateId();
    private ConnectionInfo connectionInfo;
    private PrintWriter writer;
    private String userName;
    private boolean validStream = false;

    public WireFormat copy() {
        return new JabberWireFormat();
    }

    public Packet readPacket(DataInput in) throws IOException {
        return null;
    }

    public Packet readPacket(int firstByte, DataInput in) throws IOException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readPacket(XMLStreamReader reader, List returnPackets) throws XMLStreamException, JMSException {
        String sessionId = this.getAttributeValue("id", reader);
        if (reader.next() != 1) return;
        QName name = reader.getName();
        if (!this.validStream) {
            if (name.equals(STREAM_QNAME)) {
                this.validStream = true;
                return;
            }
            String errStr = "Bad initial QName for stream. Received: " + name + " while expecting: " + STREAM_QNAME;
            log.warn((Object)errStr);
            throw new JMSException(errStr);
        }
        QName test = new QName("jabber:iq:auth", "query", "query");
        if (name.equals(AUTH_QNAME)) {
            if (!reader.hasNext()) return;
            if (reader.next() != 1) return;
            name = reader.getName();
            this.userName = reader.getElementText();
            if (reader.hasNext()) {
                reader.next();
            }
            if (reader.hasNext() && reader.next() == 1) {
                if (sessionId == null) return;
                this.writer.println(" <iq id='" + sessionId + "' type='result'/>");
                this.writer.flush();
                return;
            }
            this.writer.println("<iq id='" + sessionId + "'");
            this.writer.println(" type = 'result'>");
            this.writer.println("<query xmlns='jabber:iq:auth'><username>" + this.userName + "</username><password/><digest/><resource/></query></iq>");
            this.writer.flush();
            returnPackets.add(this.createConnectionInfo());
            returnPackets.add(this.createConsumerPacket());
            return;
        }
        if (name.equals(MESSAGE_QNAME)) {
            Packet pack = this.readMessage(reader);
            if (pack == null) return;
            returnPackets.add(pack);
            return;
        }
        if (sessionId == null) return;
        this.writer.println(" <iq id='" + sessionId + "' type='result'/>");
        this.writer.flush();
    }

    private String getAttributeValue(String attributeName, XMLStreamReader reader) {
        String result = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!reader.getAttributeName(i).toString().equals(attributeName)) continue;
            result = reader.getAttributeValue(i);
            break;
        }
        return result;
    }

    public Packet writePacket(Packet packet, DataOutput out) throws IOException, JMSException {
        switch (packet.getPacketType()) {
            case 6: {
                this.writeMessage((ActiveMQMessage)packet, "", out);
                break;
            }
            case 7: {
                this.writeTextMessage((ActiveMQTextMessage)packet, out);
                break;
            }
            case 9: {
                this.writeBytesMessage((ActiveMQBytesMessage)packet, out);
                break;
            }
            case 8: {
                this.writeObjectMessage((ActiveMQObjectMessage)packet, out);
                break;
            }
            default: {
                log.debug((Object)("Ignoring message type: " + packet.getPacketType() + " packet: " + packet));
            }
        }
        this.writer.flush();
        return null;
    }

    public boolean canProcessWireFormatVersion(int version) {
        return true;
    }

    public int getCurrentWireFormatVersion() {
        return 1;
    }

    public PrintWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    protected Packet createConnectionInfo() {
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setStarted(true);
        this.connectionInfo.setClientId(this.clientID);
        this.connectionInfo.setClientVersion("" + this.getCurrentWireFormatVersion());
        this.connectionInfo.setUserName(this.userName);
        return this.connectionInfo;
    }

    protected Packet createConsumerPacket() {
        ConsumerInfo info = new ConsumerInfo();
        info.setClientId(this.clientID);
        info.setConsumerNo(0);
        info.setStarted(true);
        info.setStartTime(System.currentTimeMillis());
        info.setDestination(this.createDestination("chat", this.userName));
        return info;
    }

    protected void initialize() throws IOException {
        String hostName = InetAddress.getLocalHost().toString();
        this.writer.println("<?xml version='1.0'?>");
        this.writer.println("<stream:stream");
        this.writer.println("  xmlns='jabber:client'");
        this.writer.println("  xml:lang='en'");
        this.writer.println("  xmlns:stream='http://etherx.jabber.org/streams'");
        this.writer.println("  from='" + hostName + "'");
        this.writer.println("  id='" + this.clientID + "'>");
        this.writer.flush();
    }

    protected Packet readMessage(XMLStreamReader reader) throws XMLStreamException, JMSException {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setJMSMessageID(this.idGenerator.generateId());
        QName name = reader.getName();
        String to = this.getAttributeValue("to", reader);
        String type = this.getAttributeValue("type", reader);
        if (type != null) {
            message.setJMSType(type);
        }
        if (to != null && to.length() > 0) {
            message.setJMSDestination(this.createDestination(type, to));
        }
        if (this.userName != null && this.userName.length() > 0) {
            message.setJMSReplyTo(this.createDestination("chat", this.userName));
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    if (this.readElement(reader, message)) break;
                    log.debug((Object)("Unknown element: " + reader.getName()));
                    break;
                }
                case 2: 
                case 8: {
                    return message;
                }
            }
        }
        return message;
    }

    protected boolean readElement(XMLStreamReader reader, ActiveMQTextMessage message) throws JMSException, XMLStreamException {
        QName name = reader.getName();
        String localPart = name.getLocalPart();
        if (localPart.equals("body")) {
            message.setText(reader.getElementText());
            return true;
        }
        if (localPart.equals("thread")) {
            message.setJMSCorrelationID(reader.getElementText());
            return true;
        }
        return false;
    }

    protected String readXMLAsText(XMLStreamReader reader) throws XMLStreamException {
        StringBuffer buffer = new StringBuffer();
        int elementCount = 0;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    if (elementCount++ <= 0) break;
                    this.writeStartElement(reader);
                    break;
                }
                case 4: {
                    buffer.append(reader.getText());
                    break;
                }
                case 2: {
                    if (--elementCount <= 0) {
                        return buffer.toString();
                    }
                    this.writeEndElement(reader);
                    break;
                }
                case 8: {
                    return buffer.toString();
                }
            }
        }
        return buffer.toString();
    }

    protected void writeStartElement(XMLStreamReader reader) {
        int i;
        this.writer.print("<");
        this.writeQName(reader.getName());
        int size = reader.getNamespaceCount();
        for (i = 0; i < size; ++i) {
            this.writer.print("xmlns");
            String prefix = reader.getNamespacePrefix(i);
            if (prefix != null && prefix.length() > 0) {
                this.writer.print(":");
                this.writer.print(prefix);
            }
            this.writer.print("='");
            this.writer.print(reader.getNamespaceURI(i));
            this.writer.print("'");
        }
        size = reader.getAttributeCount();
        for (i = 0; i < size; ++i) {
            this.writer.print("xmlns");
            this.writeQName(reader.getAttributeName(i));
            this.writer.print("='");
            this.writer.print(reader.getAttributeValue(i));
            this.writer.print("'");
        }
        this.writer.println(">");
    }

    protected void writeEndElement(XMLStreamReader reader) {
        this.writer.print("</");
        this.writeQName(reader.getName());
        this.writer.println(">");
    }

    protected void writeQName(QName name) {
        String prefix = name.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            this.writer.print(prefix);
            this.writer.print(":");
        }
        this.writer.print(name.getLocalPart());
    }

    protected ActiveMQDestination createDestination(String typeName, String text) {
        int type = 3;
        if (text.startsWith(TOPIC_PREFIX)) {
            type = 1;
            text = text.substring(TOPIC_PREFIX.length());
        } else if (text.startsWith(QUEUE_PREFIX)) {
            type = 3;
            text = text.substring(QUEUE_PREFIX.length());
        } else if (text.startsWith(TEMP_QUEUE_PREFIX)) {
            type = 4;
            text = text.substring(TEMP_QUEUE_PREFIX.length());
        } else if (text.startsWith(TEMP_TOPIC_PREFIX)) {
            type = 2;
            text = text.substring(TEMP_TOPIC_PREFIX.length());
        } else if (typeName != null && typeName.equals("groupchat")) {
            type = 1;
        }
        text = text.trim();
        if (text.length() == 0) {
            return null;
        }
        return ActiveMQDestination.createDestination(type, text);
    }

    protected String toString(Destination destination) {
        if (destination instanceof ActiveMQDestination) {
            ActiveMQDestination activeDestination = (ActiveMQDestination)destination;
            String physicalName = activeDestination.getPhysicalName();
            switch (activeDestination.getDestinationType()) {
                case 3: {
                    return QUEUE_PREFIX + physicalName;
                }
                case 4: {
                    return TEMP_QUEUE_PREFIX + physicalName;
                }
                case 2: {
                    return TEMP_TOPIC_PREFIX + physicalName;
                }
            }
            return physicalName;
        }
        return destination != null ? destination.toString() : "";
    }

    protected void writeObjectMessage(ActiveMQObjectMessage message, DataOutput out) throws JMSException, IOException {
        Serializable object = message.getObject();
        String text = object != null ? object.toString() : "";
        this.writeMessage(message, text, out);
    }

    protected void writeTextMessage(ActiveMQTextMessage message, DataOutput out) throws JMSException, IOException {
        this.writeMessage(message, message.getText(), out);
    }

    protected void writeBytesMessage(ActiveMQBytesMessage message, DataOutput out) throws IOException {
        ByteArray data = message.getBodyAsBytes();
        String text = this.encodeBinary(data.getBuf(), data.getOffset(), data.getLength());
        this.writeMessage(message, text, out);
    }

    protected void writeMessage(ActiveMQMessage message, String body, DataOutput out) throws IOException {
        HashMap properties;
        String type = this.getXmppType(message);
        this.writer.print("<");
        this.writer.print(type);
        this.writer.print(" to='");
        this.writer.print(this.toString(message.getJMSDestination()));
        this.writer.print("' from='");
        this.writer.print(this.toString(message.getJMSReplyTo()));
        String messageID = message.getJMSMessageID();
        if (messageID != null) {
            this.writer.print("' id='");
            this.writer.print(messageID);
        }
        if ((properties = message.getProperties()) != null) {
            Iterator iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                this.writer.print("' ");
                this.writer.print(key.toString());
                this.writer.print("='");
                this.writer.print(value.toString());
            }
        }
        this.writer.println("'>");
        String id = message.getJMSCorrelationID();
        if (id != null) {
            this.writer.print("<thread>");
            this.writer.print(id);
            this.writer.print("</thread>");
        }
        this.writer.print("<body>");
        this.writer.print(body);
        this.writer.println("</body>");
        this.writer.print("</");
        this.writer.print(type);
        this.writer.println(">");
    }

    protected String encodeBinary(byte[] data, int offset, int length) {
        throw new RuntimeException("Not implemented yet!");
    }

    protected String getXmppType(ActiveMQMessage message) {
        String type = message.getJMSType();
        if (type == null) {
            type = "message";
        }
        return type;
    }
}

