/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.itest.ejb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MDBTransferBean
implements MessageDrivenBean,
MessageListener {
    private static final Log log = LogFactory.getLog((Class)MDBTransferBean.class);

    public void ejbCreate() {
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        System.out.println("entering onMessage");
        try {
            this.printCompEnv();
            InitialContext jndiContext = new InitialContext();
            ConnectionFactory cf = (ConnectionFactory)jndiContext.lookup("java:comp/env/jms/Default");
            Connection con = cf.createConnection();
            try {
                Session session = con.createSession(true, 0);
                Queue q = (Queue)jndiContext.lookup("java:comp/env/jms/OutQueue");
                MessageProducer producer = session.createProducer((Destination)q);
                producer.send(message);
            }
            finally {
                con.close();
            }
        }
        catch (NamingException e) {
            log.info((Object)e);
        }
        catch (JMSException e) {
            log.info((Object)e);
        }
        System.out.println("leaving onMessage");
    }

    private void printCompEnv() throws NamingException {
        log.warn((Object)"Printing java:comp/env/jms context: ");
        Context c = (Context)new InitialContext().lookup("java:comp/env/jms");
        NamingEnumeration<NameClassPair> iter = c.list("");
        while (iter.hasMoreElements()) {
            NameClassPair pair = iter.next();
            log.warn((Object)("'" + pair.getName() + "'"));
        }
    }
}

