/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.jdbm;

import java.io.IOException;
import javax.jms.JMSException;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.AlreadyClosedException;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.MessageIdentity;
import org.codehaus.activemq.service.QueueMessageContainer;
import org.codehaus.activemq.service.impl.MessageEntry;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class JdbmMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)JdbmMessageStore.class);
    private MessageContainer container;
    private BTree messageTable;
    private BTree orderedIndex;
    private long lastSequenceNumber = 0L;

    public JdbmMessageStore(BTree messageTable, BTree orderedIndex) {
        this.messageTable = messageTable;
        this.orderedIndex = orderedIndex;
    }

    public void setMessageContainer(MessageContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MessageIdentity addMessage(ActiveMQMessage message) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding message to container: " + message));
        }
        MessageEntry entry = new MessageEntry(message);
        Long sequenceNumber = null;
        JdbmMessageStore jdbmMessageStore = this;
        synchronized (jdbmMessageStore) {
            sequenceNumber = new Long(++this.lastSequenceNumber);
        }
        try {
            String messageID = message.getJMSMessageID();
            this.getMessageTable().insert((Object)messageID, (Object)entry, true);
            this.getOrderedIndex().insert((Object)sequenceNumber, (Object)messageID, true);
            MessageIdentity answer = message.getJMSMessageIdentity();
            answer.setSequenceNumber((Object)sequenceNumber);
            return answer;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to add message: " + message + " in container: " + e), (Exception)e);
        }
    }

    public synchronized ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        String messageID = identity.getMessageID();
        ActiveMQMessage message = null;
        try {
            MessageEntry entry = (MessageEntry)this.getMessageTable().find((Object)messageID);
            if (entry != null) {
                message = entry.getMessage();
                message.getJMSMessageIdentity().setSequenceNumber(identity.getSequenceNumber());
            }
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to get message for messageID: " + messageID + " " + e), (Exception)e);
        }
        return message;
    }

    public synchronized void removeMessage(MessageIdentity identity, MessageAck ack) throws JMSException {
        String messageID = identity.getMessageID();
        Object sequenceNumber = null;
        if (messageID == null) {
            throw new JMSException("Cannot remove message with null messageID for sequence number: " + identity.getSequenceNumber());
        }
        try {
            sequenceNumber = identity.getSequenceNumber();
            if (sequenceNumber == null) {
                sequenceNumber = this.findSequenceNumber(messageID);
                identity.setSequenceNumber(sequenceNumber);
            }
            this.getMessageTable().remove((Object)messageID);
            this.getOrderedIndex().remove(sequenceNumber);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to delete message for messageID: " + messageID + " " + e), (Exception)e);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Could not find sequence number: " + sequenceNumber + " in queue. " + e));
        }
    }

    public synchronized void recover(QueueMessageContainer container) throws JMSException {
        try {
            Tuple tuple = new Tuple();
            TupleBrowser iter = this.getOrderedIndex().browse();
            while (iter.getNext(tuple)) {
                String messageID;
                Long key = (Long)tuple.getKey();
                MessageIdentity messageIdentity = null;
                if (key != null && (messageID = (String)tuple.getValue()) != null) {
                    messageIdentity = new MessageIdentity(messageID, (Object)key);
                }
                if (messageIdentity != null) {
                    container.recoverMessageToBeDelivered(messageIdentity);
                    continue;
                }
                log.warn((Object)("Could not find message for sequenceNumber: " + key));
            }
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to recover the durable queue store. Reason: " + e), (Exception)e);
        }
    }

    public synchronized void start() throws JMSException {
        try {
            Tuple tuple = new Tuple();
            Long lastSequenceNumber = null;
            TupleBrowser iter = this.getOrderedIndex().browse();
            while (iter.getNext(tuple)) {
                lastSequenceNumber = (Long)tuple.getKey();
            }
            if (lastSequenceNumber != null) {
                this.lastSequenceNumber = lastSequenceNumber;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Last sequence number is: " + lastSequenceNumber + " for: " + this));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Started empty database for: " + this));
            }
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to find the last sequence number. Reason: " + e), (Exception)e);
        }
    }

    public synchronized void stop() throws JMSException {
        JMSException firstException = this.closeTable(this.orderedIndex, null);
        firstException = this.closeTable(this.messageTable, firstException);
        this.orderedIndex = null;
        this.messageTable = null;
        if (firstException != null) {
            throw firstException;
        }
    }

    protected MessageContainer getContainer() {
        return this.container;
    }

    protected long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    protected BTree getMessageTable() throws AlreadyClosedException {
        if (this.messageTable == null) {
            throw new AlreadyClosedException("JDBM MessageStore");
        }
        return this.messageTable;
    }

    protected BTree getOrderedIndex() throws AlreadyClosedException {
        if (this.orderedIndex == null) {
            throw new AlreadyClosedException("JDBM MessageStore");
        }
        return this.orderedIndex;
    }

    protected ActiveMQMessage getMessageBySequenceNumber(Long sequenceNumber) throws IOException, JMSException {
        ActiveMQMessage message = null;
        String messageID = (String)this.getOrderedIndex().find((Object)sequenceNumber);
        if (messageID != null) {
            message = this.getMessage(new MessageIdentity(messageID, (Object)sequenceNumber));
        }
        return message;
    }

    protected Object findSequenceNumber(String messageID) throws IOException, AlreadyClosedException {
        log.warn((Object)("Having to table scan to find the sequence number for messageID: " + messageID));
        Tuple tuple = new Tuple();
        TupleBrowser iter = this.getOrderedIndex().browse();
        while (iter.getNext(tuple)) {
            Object value = tuple.getValue();
            if (!messageID.equals(value)) continue;
            return tuple.getKey();
        }
        return null;
    }

    protected JMSException closeTable(BTree table, JMSException firstException) {
        table = null;
        return null;
    }
}

