/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.jdbm;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.AlreadyClosedException;
import org.codehaus.activemq.service.impl.PersistenceAdapterSupport;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.PreparedTransactionStore;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.jdbm.JdbmMessageStore;
import org.codehaus.activemq.store.jdbm.JdbmPreparedTransactionStore;
import org.codehaus.activemq.store.jdbm.JdbmTopicMessageStore;
import org.codehaus.activemq.util.DefaultComparator;
import org.codehaus.activemq.util.JMSExceptionHelper;

public class JdbmPersistenceAdapter
extends PersistenceAdapterSupport {
    private static final Log log = LogFactory.getLog((Class)JdbmPersistenceAdapter.class);
    private RecordManager manager;
    private File directory = new File("ActiveMQ");
    private Properties properties;

    public static JdbmPersistenceAdapter newInstance(File directory) throws JMSException {
        return new JdbmPersistenceAdapter(directory);
    }

    public JdbmPersistenceAdapter() {
    }

    public JdbmPersistenceAdapter(File directory) {
        this.directory = directory;
    }

    public JdbmPersistenceAdapter(RecordManager manager) {
        this.manager = manager;
    }

    public Map getInitialDestinations() {
        return null;
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        try {
            BTree messageDb = this.createDatabase("Queue_" + destinationName);
            BTree sequenceDb = this.createDatabase("Sequence_Queue_" + destinationName);
            JdbmMessageStore messageStore = new JdbmMessageStore(messageDb, sequenceDb);
            return messageStore;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to create a QueueMessageContainer for destination: " + destinationName + ". Reason: " + e), (Exception)e);
        }
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        try {
            BTree messageDb = this.createDatabase("Topic_" + destinationName);
            BTree sequenceDb = this.createDatabase("Sequence_Topic_" + destinationName);
            BTree consumerAckDb = this.createDatabase("Consumer_Acks_Topic_" + destinationName);
            BTree subscriberDb = this.createDatabase("Subscriber_" + destinationName);
            BTree messageCountDb = this.createDatabase("MessageCount_Topic_" + destinationName);
            JdbmTopicMessageStore messageStore = new JdbmTopicMessageStore(messageDb, sequenceDb, consumerAckDb, subscriberDb, messageCountDb);
            return messageStore;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Failed to create a TopicMessageContainer for destination: " + destinationName + ". Reason: " + e), (Exception)e);
        }
    }

    public PreparedTransactionStore createPreparedTransactionStore() throws JMSException {
        try {
            return new JdbmPreparedTransactionStore(this.createDatabase("XaPrepareTxnDb"));
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Could not create XA Prepare Transaction Database. Reason: " + e), (Exception)e);
        }
    }

    public void beginTransaction() {
    }

    public void commitTransaction() throws JMSException {
        try {
            this.manager.commit();
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Could not commit transaction. Reason: " + e), (Exception)e);
        }
    }

    public void rollbackTransaction() {
        try {
            this.manager.rollback();
        }
        catch (IOException e) {
            log.error((Object)("Could not rollback transaction. Reason: " + e), (Throwable)e);
        }
    }

    public void start() throws JMSException {
        if (this.manager == null) {
            this.directory.mkdirs();
            log.info((Object)("Creating JDBM based message store in directory: " + this.directory.getAbsolutePath()));
            try {
                String name = this.directory.getAbsolutePath() + "/Store";
                this.manager = this.properties != null ? RecordManagerFactory.createRecordManager((String)name, (Properties)this.properties) : RecordManagerFactory.createRecordManager((String)name);
            }
            catch (IOException e) {
                throw JMSExceptionHelper.newJMSException((String)("Failed to create JDBM persistent store at directory: " + this.directory + ". Reason: " + e), (Exception)e);
            }
        }
    }

    public synchronized void stop() throws JMSException {
        if (this.manager != null) {
            try {
                this.manager.close();
            }
            catch (IOException e) {
                throw JMSExceptionHelper.newJMSException((String)("Failed to close PersistenceAdapter. Reason: " + e), (Exception)e);
            }
            finally {
                this.manager = null;
            }
        }
    }

    public RecordManager getManager() {
        return this.manager;
    }

    public void setManager(RecordManager manager) {
        this.manager = manager;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public synchronized BTree createDatabase(String name) throws IOException, AlreadyClosedException {
        if (this.manager == null) {
            throw new AlreadyClosedException("JDBM PersistenceAdapter");
        }
        long recid = this.manager.getNamedObject(name);
        BTree tree = null;
        if (recid != 0L) {
            tree = BTree.load((RecordManager)this.manager, (long)recid);
        } else {
            DefaultComparator comparator = new DefaultComparator();
            tree = BTree.createInstance((RecordManager)this.manager, (Comparator)comparator);
            this.manager.setNamedObject(name, tree.getRecid());
        }
        return tree;
    }
}

