/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.web;

import java.io.IOException;
import javax.jms.JMSException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activemq.broker.BrokerContainer;
import org.activemq.spring.SpringBrokerContainerFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.ServletContextResource;

public class SpringBrokerServlet
extends HttpServlet {
    private BrokerContainer brokerContainer;

    public void init() throws ServletException {
        this.log("Creating ActiveMQ Broker");
        this.brokerContainer = this.createBroker(this.getServletContext());
        this.log("Starting ActiveMQ Broker");
        try {
            this.brokerContainer.start();
            this.log("Started ActiveMQ Broker");
        }
        catch (JMSException e) {
            throw new ServletException("Failed to start ActiveMQ broker: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void destroy() {
        if (this.brokerContainer != null) {
            try {
                this.brokerContainer.stop();
            }
            catch (JMSException e) {
                this.log("Failed to stop the ActiveMQ Broker: " + (Object)((Object)e), e);
            }
        }
        super.destroy();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.getServletContext().log("Attempt to call service method on SpringBrokerServlet as [" + request.getRequestURI() + "] was ignored");
        response.sendError(400);
    }

    public String getServletInfo() {
        return "SpringBrokerServlet for deploying the ActiveMQ Broker in a servlet engine";
    }

    protected BrokerContainer createBroker(ServletContext context) {
        String brokerURI = context.getInitParameter("brokerURI");
        if (brokerURI == null) {
            brokerURI = "activemq.xml";
        }
        this.log("Loading ActiveMQ Broker configuration from: " + brokerURI);
        ServletContextResource resource = new ServletContextResource(context, brokerURI);
        return SpringBrokerContainerFactory.newInstance((Resource)resource);
    }
}

