/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl;

import java.util.Vector;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.common.ThreadPoolAware;
import org.apache.altrmi.server.MethodInvocationHandler;
import org.apache.altrmi.server.PublicationDescription;
import org.apache.altrmi.server.PublicationException;
import org.apache.altrmi.server.Server;
import org.apache.altrmi.server.ServerConnection;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.ServerSideClientContextFactory;
import org.apache.altrmi.server.impl.adaptors.InvocationHandlerAdaptor;

public abstract class AbstractServer
implements Server,
ThreadPoolAware {
    private Vector m_connections = new Vector();
    private InvocationHandlerAdaptor m_invocationHandlerAdaptor;
    private int m_state = 505;
    protected final ServerMonitor m_serverMonitor;
    protected final ThreadPool m_threadPool;
    protected final ServerSideClientContextFactory m_contextFactory;

    public AbstractServer(InvocationHandlerAdaptor invocationHandlerAdapter, ServerMonitor serverMonitor, ThreadPool threadPool, ServerSideClientContextFactory contextFactory) {
        this.m_invocationHandlerAdaptor = invocationHandlerAdapter;
        this.m_serverMonitor = serverMonitor;
        this.m_threadPool = threadPool;
        this.m_contextFactory = contextFactory;
    }

    public synchronized ThreadPool getThreadPool() {
        return this.m_threadPool;
    }

    public Reply handleInvocation(Request request, Object connectionDetails) {
        return this.m_invocationHandlerAdaptor.handleInvocation(request, connectionDetails);
    }

    public void suspend() {
        this.m_invocationHandlerAdaptor.suspend();
    }

    public void resume() {
        this.m_invocationHandlerAdaptor.resume();
    }

    protected void connectionStart(ServerConnection connection) {
        this.m_connections.add(connection);
    }

    protected void connectionCompleted(ServerConnection connection) {
        this.m_connections.remove(connection);
    }

    protected void killAllConnections() {
        ServerConnection[] connections = this.m_connections.toArray(new ServerConnection[0]);
        for (int i = 0; i < connections.length; ++i) {
            connections[i].endConnection();
        }
    }

    public void publish(Object impl, String asName, Class interfaceToExpose) throws PublicationException {
        this.m_invocationHandlerAdaptor.publish(impl, asName, interfaceToExpose);
    }

    public void publish(Object impl, String asName, PublicationDescription publicationDescription) throws PublicationException {
        this.m_invocationHandlerAdaptor.publish(impl, asName, publicationDescription);
    }

    public void unPublish(Object impl, String asName) throws PublicationException {
        this.m_invocationHandlerAdaptor.unPublish(impl, asName);
    }

    public void replacePublished(Object oldImpl, String publishedName, Object withImpl) throws PublicationException {
        this.m_invocationHandlerAdaptor.replacePublished(oldImpl, publishedName, withImpl);
    }

    public MethodInvocationHandler getMethodInvocationHandler(MethodRequest methodRequest, String objectName) {
        return this.m_invocationHandlerAdaptor.getMethodInvocationHandler(methodRequest, objectName);
    }

    public MethodInvocationHandler getMethodInvocationHandler(String publishedName) {
        return this.m_invocationHandlerAdaptor.getMethodInvocationHandler(publishedName);
    }

    public InvocationHandlerAdaptor getInovcationHandlerAdapter() {
        return this.m_invocationHandlerAdaptor;
    }

    protected void setState(int state) {
        this.m_state = state;
    }

    protected int getState() {
        return this.m_state;
    }

    protected ServerSideClientContextFactory getClientContextFactory() {
        return this.m_contextFactory;
    }
}

