/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.altrmi.common.ExceptionReply;
import org.apache.altrmi.common.FacadeRefHolder;
import org.apache.altrmi.common.InvocationExceptionReply;
import org.apache.altrmi.common.MethodReply;
import org.apache.altrmi.common.MethodRequest;
import org.apache.altrmi.common.NoSuchReferenceReply;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.server.MethodInvocationHandler;
import org.apache.altrmi.server.MethodInvocationMonitor;
import org.apache.altrmi.server.PublicationDescription;
import org.apache.altrmi.server.Publisher;
import org.apache.altrmi.server.impl.NullMethodInvocationMonitor;

public class DefaultMethodInvocationHandler
implements MethodInvocationHandler {
    private MessageFormat messageFormat = new MessageFormat("");
    private WeakHashMap m_refBeans = new WeakHashMap();
    private WeakHashMap m_beanRefs = new WeakHashMap();
    private HashMap m_methodMap;
    private static int c_nextReference = 0;
    private Publisher m_publisher;
    private String m_publishedThing;
    private Object m_beanImpl;
    private final PublicationDescription m_publicationDescription;
    private MethodInvocationMonitor m_methodInvocationMonitor = new NullMethodInvocationMonitor();

    public DefaultMethodInvocationHandler(Publisher publisher, String publishedThing, HashMap methodMap, PublicationDescription publicationDescription) {
        this.m_publisher = publisher;
        this.m_publishedThing = publishedThing;
        this.m_methodMap = methodMap;
        this.m_publicationDescription = publicationDescription;
    }

    public String toString() {
        return "DMIH:" + this.m_publishedThing;
    }

    public void addImplementationBean(Long referenceID, Object beanImpl) {
        if (referenceID.equals(new Long(0L))) {
            this.m_beanImpl = beanImpl;
        }
        this.m_refBeans.put(referenceID, new WeakReference<Object>(beanImpl));
        this.m_beanRefs.put(beanImpl, referenceID);
    }

    public void replaceImplementationBean(Object implBean, Object withImplBean) {
        Long ref = (Long)this.m_beanRefs.get(implBean);
        this.m_refBeans.put(ref, new WeakReference<Object>(withImplBean));
        this.m_beanRefs.remove(implBean);
        this.m_beanRefs.put(withImplBean, ref);
        if (this.m_beanImpl == implBean) {
            this.m_beanImpl = withImplBean;
        }
    }

    public Long getOrMakeReferenceIDForBean(Object implBean) {
        Long ref = (Long)this.m_beanRefs.get(implBean);
        if (ref == null) {
            ref = this.getNewReference();
            this.addImplementationBean(ref, implBean);
        }
        return ref;
    }

    public Reply handleMethodInvocation(MethodRequest request, Object connectionDetails) {
        String methodSignature = request.getMethodSignature();
        if (!this.m_methodMap.containsKey(methodSignature)) {
            this.m_methodInvocationMonitor.missingMethod(methodSignature, connectionDetails);
            return new InvocationExceptionReply("Method '" + methodSignature + "' not present in impl");
        }
        Method method = (Method)this.m_methodMap.get(methodSignature);
        Object beanImpl = null;
        try {
            WeakReference wr = (WeakReference)this.m_refBeans.get(request.getReferenceID());
            if (wr == null) {
                this.m_methodInvocationMonitor.invalidReference(methodSignature, connectionDetails);
                return new NoSuchReferenceReply(request.getReferenceID());
            }
            beanImpl = wr.get();
            if (beanImpl == null) {
                this.m_methodInvocationMonitor.invalidReference(methodSignature, connectionDetails);
                return new NoSuchReferenceReply(request.getReferenceID());
            }
            Object[] args = request.getArgs();
            this.correctArgs(request, args);
            this.m_methodInvocationMonitor.methodInvoked(beanImpl.getClass(), methodSignature, connectionDetails);
            return new MethodReply(method.invoke(beanImpl, request.getArgs()));
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            this.m_methodInvocationMonitor.invocationTargetException(beanImpl.getClass(), methodSignature, ite, connectionDetails);
            if (t instanceof Serializable) {
                return new ExceptionReply(t);
            }
            return new InvocationExceptionReply("Exception was not serializable :" + t.getClass().getName());
        }
        catch (Throwable t) {
            this.m_methodInvocationMonitor.invocationException(beanImpl == null ? null : beanImpl.getClass(), methodSignature, t, connectionDetails);
            return new InvocationExceptionReply("Some ServerSide exception problem :" + t.getMessage());
        }
    }

    private void correctArgs(MethodRequest methodRequest, Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof FacadeRefHolder)) continue;
            FacadeRefHolder frh = (FacadeRefHolder)args[i];
            DefaultMethodInvocationHandler methodInvocationHandler = (DefaultMethodInvocationHandler)this.m_publisher.getMethodInvocationHandler(frh.getObjectName());
            WeakReference wr = (WeakReference)methodInvocationHandler.m_refBeans.get(frh.getReferenceID());
            args[i] = wr.get();
        }
    }

    public Class getMostDerivedType(Object beanImpl) {
        return this.m_publicationDescription.getMostDerivedType(beanImpl);
    }

    public String encodeClassName(String className) {
        return className.replace('.', '$');
    }

    public String[] getListOfMethods() {
        String[] methodNames = this.m_methodMap.keySet().toArray(new String[0]);
        return methodNames;
    }

    private Long getNewReference() {
        return new Long((long)(++c_nextReference << 16) + (long)(Math.random() * 65536.0));
    }

    public void setMethodInvocationMonitor(MethodInvocationMonitor monitor) {
        this.m_methodInvocationMonitor = monitor;
    }
}

