/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.callback;

import org.apache.altrmi.client.HostContext;
import org.apache.altrmi.client.impl.AbstractFactory;
import org.apache.altrmi.client.impl.DefaultProxyHelper;
import org.apache.altrmi.client.impl.ServerSideClassFactory;
import org.apache.altrmi.common.Authentication;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ExceptionReply;
import org.apache.altrmi.common.LookupReply;
import org.apache.altrmi.common.LookupRequest;
import org.apache.altrmi.common.NotPublishedReply;
import org.apache.altrmi.common.OpenConnectionReply;
import org.apache.altrmi.common.OpenConnectionRequest;
import org.apache.altrmi.common.Reply;
import org.apache.altrmi.common.Request;

public class CallbackServerClassFactory
extends ServerSideClassFactory {
    public CallbackServerClassFactory(HostContext hostContext, boolean allowOptimize) throws ConnectionException {
        super(hostContext, allowOptimize);
    }

    public Object lookup(String publishedServiceName, Authentication authentication) throws ConnectionException {
        if (this.m_session == null) {
            OpenConnectionReply reply = (OpenConnectionReply)this.m_hostContext.getInvocationHandler().handleInvocation((Request)new OpenConnectionRequest());
            this.m_session = reply.getSession();
        }
        String modifiedPublishedName = publishedServiceName.substring(0, publishedServiceName.lastIndexOf("_"));
        Reply ar = this.m_hostContext.getInvocationHandler().handleInvocation((Request)new LookupRequest(modifiedPublishedName, authentication, this.m_session));
        if (ar.getReplyCode() >= 100) {
            if (ar instanceof NotPublishedReply) {
                throw new ConnectionException("Service " + publishedServiceName + " not published");
            }
            if (ar instanceof ExceptionReply) {
                ExceptionReply er = (ExceptionReply)ar;
                throw (ConnectionException)er.getReplyException();
            }
            throw new ConnectionException("Problem doing lookup on service");
        }
        LookupReply lr = (LookupReply)ar;
        DefaultProxyHelper baseObj = new DefaultProxyHelper((AbstractFactory)this, this.m_hostContext.getInvocationHandler(), publishedServiceName, "Main", lr.getReferenceID(), this.m_session);
        Object retVal = this.getInstance(modifiedPublishedName, "Main", baseObj);
        baseObj.registerImplObject(retVal);
        return retVal;
    }
}

