/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.classretrievers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.altrmi.server.ClassRetrievalException;
import org.apache.altrmi.server.ClassRetriever;

public abstract class AbstractClassRetriever
implements ClassRetriever {
    private ClassLoader m_classLoader;

    protected void setClassLoader(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    public final byte[] getProxyClassBytes(String publishedName) throws ClassRetrievalException {
        return this.getThingBytes("AltrmiGenerated" + publishedName);
    }

    protected byte[] getThingBytes(String thingName) throws ClassRetrievalException {
        InputStream is = null;
        thingName = thingName.replace('.', '\\') + ".class";
        try {
            is = this.m_classLoader.getResourceAsStream(thingName);
        }
        catch (Exception e) {
            throw new ClassRetrievalException("Generated class not found in classloader specified : " + e.getMessage());
        }
        if (is == null) {
            throw new ClassRetrievalException("Generated class not found in classloader specified.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        try {
            while (-1 != (i = is.read())) {
                baos.write(i);
            }
            is.close();
        }
        catch (IOException e) {
            throw new ClassRetrievalException("Error retrieving generated class bytes : " + e.getMessage());
        }
        return baos.toByteArray();
    }
}

