/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.classretrievers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.altrmi.server.ClassRetrievalException;
import org.apache.altrmi.server.ClassRetriever;
import org.apache.altrmi.server.ProxyGenerationEnvironmentException;
import org.apache.altrmi.server.ProxyGenerator;
import org.apache.altrmi.server.PublicationDescription;
import org.apache.altrmi.server.PublicationDescriptionItem;
import org.apache.altrmi.server.PublicationException;

public class AbstractDynamicGeneratorClassRetriever
implements ProxyGenerator,
ClassRetriever {
    private String m_classpath;
    private String m_classGenDir = ".";
    private String m_srcGenDir;
    private Class m_generatorClass;

    public AbstractDynamicGeneratorClassRetriever(ClassLoader classLoader, String generatorClassName) {
        try {
            this.m_generatorClass = classLoader.loadClass(generatorClassName);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(generatorClassName);
        }
    }

    public void generate(String asName, Class interfaceToExpose, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, new PublicationDescription(interfaceToExpose), classLoader, false);
    }

    public void generate(String asName, PublicationDescription publicationDescription, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, publicationDescription, classLoader, false);
    }

    public void deferredGenerate(String asName, PublicationDescription publicationDescription, ClassLoader classLoader) throws PublicationException {
        this.generateProxy(asName, publicationDescription, classLoader, true);
    }

    public void setClasspath(String classpath) {
        this.m_classpath = classpath;
    }

    public void addToClasspath(String classpathElement) {
        this.m_classpath = this.m_classpath + File.pathSeparator + classpathElement;
    }

    public void setClassGenDir(String classGenDir) {
        this.m_classGenDir = classGenDir;
    }

    public final byte[] getProxyClassBytes(String publishedName) throws ClassRetrievalException {
        return this.getThingBytes("AltrmiGenerated" + publishedName);
    }

    protected byte[] getThingBytes(String thingName) throws ClassRetrievalException {
        FileInputStream fis;
        thingName = thingName.replace('.', '\\') + ".class";
        try {
            fis = new FileInputStream(new File(this.m_classGenDir, thingName));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClassRetrievalException("Generated class not found in classloader specified : " + e.getMessage());
        }
        if (fis == null) {
            throw new ClassRetrievalException("Generated class not found in classloader specified.");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        try {
            while (-1 != (i = fis.read())) {
                baos.write(i);
            }
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ClassRetrievalException("Error retrieving generated class bytes : " + e.getMessage());
        }
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public void setSrcGenDir(String srcGenDir) {
        this.m_srcGenDir = srcGenDir;
    }

    private void generateProxy(String asName, PublicationDescription publicationDescription, ClassLoader classLoader, boolean deferred) throws PublicationException {
        String aString;
        int i;
        org.apache.altrmi.common.ProxyGenerator proxyGenerator;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        PublicationDescriptionItem[] interfacesToExpose = new PublicationDescriptionItem[]{};
        PublicationDescriptionItem[] addInfs = new PublicationDescriptionItem[]{};
        interfacesToExpose = publicationDescription.getInterfacesToExpose();
        addInfs = publicationDescription.getAdditionalFacades();
        try {
            proxyGenerator = (org.apache.altrmi.common.ProxyGenerator)this.m_generatorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("ProxyGenerator cannot be instantiated.");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("ProxyGenerator was illegally accessed");
        }
        proxyGenerator.setSrcGenDir(this.m_srcGenDir);
        proxyGenerator.setClassGenDir(this.m_classGenDir);
        proxyGenerator.setGenName(asName);
        proxyGenerator.setClasspath(this.m_classpath);
        proxyGenerator.setInterfacesToExpose(interfacesToExpose);
        proxyGenerator.setAdditionalFacades(addInfs);
        try {
            proxyGenerator.generateSrc(classLoader);
        }
        catch (Throwable t) {
            System.err.println("******");
            System.err.println("** Exception while making source : ");
            System.err.flush();
            t.printStackTrace();
            System.err.println("** Name=" + asName);
            System.err.println("** Classes/Interfaces to Expose..");
            for (i = 0; i < interfacesToExpose.length; ++i) {
                aString = interfacesToExpose[i].getFacadeClass().getName();
                System.err.println("** .." + aString);
            }
            System.err.println("******");
            System.err.flush();
        }
        if (!deferred) {
            try {
                proxyGenerator.generateClass(classLoader);
            }
            catch (Throwable t) {
                if (t instanceof NoClassDefFoundError && t.getMessage().equals("sun/tools/javac/Main")) {
                    System.err.println("***************************************");
                    System.err.println("*                                     *");
                    System.err.println("* AltRMI problem......                *");
                    System.err.println("* Please copy JAVA_HOME/lib/tools.jar *");
                    System.err.println("* to your applications m_classpath so   *");
                    System.err.println("* that proxys can be compiled.        *");
                    System.err.println("*                                     *");
                    System.err.println("***************************************");
                    throw new ProxyGenerationEnvironmentException("tools.jar not found in m_classpath.");
                }
                System.err.println("******");
                System.err.println("** Exception while making String : ");
                System.err.flush();
                t.printStackTrace();
                System.err.println("** SrcDir=" + this.m_srcGenDir);
                System.err.println("** ClassDir=" + this.m_classGenDir);
                System.err.println("** Name=" + asName);
                System.err.println("** CLasspath=" + this.m_classpath);
                System.err.println("** Classes/Interfaces to Expose..");
                for (i = 0; i < interfacesToExpose.length; ++i) {
                    aString = interfacesToExpose[i].getFacadeClass().getName();
                    System.err.println("** .." + aString);
                }
                System.err.println("******");
                System.err.flush();
            }
        }
    }

    public void generateDeferred(ClassLoader classLoader) {
        org.apache.altrmi.common.ProxyGenerator proxyGenerator;
        try {
            proxyGenerator = (org.apache.altrmi.common.ProxyGenerator)this.m_generatorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("ProxyGenerator cannot be instantiated.");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("ProxyGenerator was illegally accessed");
        }
        proxyGenerator.generateDeferredClasses();
    }
}

