/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.piped;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.altrmi.common.ConnectionException;
import org.apache.altrmi.common.ThreadContext;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.Authenticator;
import org.apache.altrmi.server.ClassRetriever;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.ServerSideClientContextFactory;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.altrmi.server.impl.adaptors.InvocationHandlerAdaptor;
import org.apache.altrmi.server.impl.piped.PipedStreamServerConnection;

public abstract class AbstractPipedServer
extends AbstractServer {
    public AbstractPipedServer(ClassRetriever classRetriever, Authenticator authenticator, ServerMonitor serverMonitor, ThreadPool threadPool, ServerSideClientContextFactory contextFactory) {
        super(new InvocationHandlerAdaptor(classRetriever, authenticator, serverMonitor, contextFactory), serverMonitor, threadPool, contextFactory);
    }

    public AbstractPipedServer(InvocationHandlerAdaptor invocationHandlerAdapter, ServerMonitor serverMonitor, ThreadPool threadPool, ServerSideClientContextFactory contextFactory) {
        super(invocationHandlerAdapter, serverMonitor, threadPool, contextFactory);
    }

    public void makeNewConnection(PipedInputStream in, PipedOutputStream out) throws ConnectionException {
        if (this.getState() == 505 | this.getState() == 202) {
            throw new ConnectionException("Server not started yet");
        }
        if (this.getState() == 101) {
            throw new ConnectionException("Server is Shutting down");
        }
        try {
            PipedInputStream pIS = new PipedInputStream();
            PipedOutputStream pOS = new PipedOutputStream();
            pIS.connect(out);
            in.connect(pOS);
            AbstractServerStreamReadWriter ssrw = this.createServerStreamReadWriter();
            ssrw.setStreams(pIS, pOS, "piped");
            PipedStreamServerConnection pssc = new PipedStreamServerConnection(this, pIS, pOS, ssrw, this.m_serverMonitor);
            ThreadContext thread = this.getThreadPool().getThreadContext((Runnable)pssc);
            thread.start();
        }
        catch (IOException pe) {
            throw new ConnectionException("Some problem setting up server : " + pe.getMessage());
        }
    }

    public void start() {
        this.setState(303);
    }

    public void stop() {
        this.setState(101);
        this.killAllConnections();
        this.setState(404);
    }

    protected abstract AbstractServerStreamReadWriter createServerStreamReadWriter();
}

