/*
 * Decompiled with CFR 0.152.
 */
package org.apache.altrmi.server.impl.socket;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.altrmi.common.ThreadPool;
import org.apache.altrmi.server.ServerMonitor;
import org.apache.altrmi.server.ServerSideClientContextFactory;
import org.apache.altrmi.server.impl.AbstractServer;
import org.apache.altrmi.server.impl.AbstractServerStreamReadWriter;
import org.apache.altrmi.server.impl.adaptors.InvocationHandlerAdaptor;
import org.apache.altrmi.server.impl.socket.SocketStreamServerConnection;

public abstract class AbstractPartialSocketStreamServer
extends AbstractServer {
    public AbstractPartialSocketStreamServer(InvocationHandlerAdaptor invocationHandlerAdapter, ServerMonitor serverMonitor, ThreadPool threadPool, ServerSideClientContextFactory contextFactory) {
        super(invocationHandlerAdapter, serverMonitor, threadPool, contextFactory);
    }

    public void handleConnection(Socket socket) {
        try {
            socket.setSoTimeout(36000);
        }
        catch (SocketException se) {
            this.m_serverMonitor.unexpectedException(this.getClass(), "AbstractPartialSocketStreamServer.handleConnection(): Some error during socket handling", (Exception)se);
        }
        try {
            if (this.getState() == 303) {
                AbstractServerStreamReadWriter ssrw = this.createServerStreamReadWriter();
                ssrw.setStreams(socket.getInputStream(), socket.getOutputStream(), socket);
                SocketStreamServerConnection sssc = new SocketStreamServerConnection(this, socket, ssrw, this.m_serverMonitor);
                sssc.run();
            }
        }
        catch (IOException ioe) {
            this.m_serverMonitor.unexpectedException(this.getClass(), "AbstractPartialSocketStreamServer.handleConnection(): Some problem connecting client via sockets: ", (Exception)ioe);
        }
    }

    protected abstract AbstractServerStreamReadWriter createServerStreamReadWriter();

    public void start() {
        this.setState(303);
    }

    public void stop() {
        this.setState(101);
        this.killAllConnections();
        this.setState(404);
    }
}

