/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.aspectj.asm.IRelationship;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public class Checker
extends ShadowMunger {
    private String msg;
    private boolean isError;
    private volatile int hashCode = -1;

    public Checker(DeclareErrorOrWarning deow) {
        super(deow.getPointcut(), deow.getStart(), deow.getEnd(), deow.getSourceContext());
        this.msg = deow.getMessage();
        this.isError = deow.isError();
    }

    private Checker(Pointcut pc, int start, int end, ISourceContext context) {
        super(pc, start, end, context);
    }

    public ShadowMunger concretize(ResolvedType fromType, World world, PerClause clause) {
        this.pointcut = this.pointcut.concretize(fromType, this.getDeclaringType(), 0, this);
        return this;
    }

    public void specializeOn(Shadow shadow) {
        throw new RuntimeException("illegal state");
    }

    public void implementOn(Shadow shadow) {
        throw new RuntimeException("illegal state");
    }

    public ShadowMunger parameterizeWith(ResolvedType declaringType, Map typeVariableMap) {
        Checker ret = new Checker(this.getPointcut().parameterizeWith(typeVariableMap), this.getStart(), this.getEnd(), this.sourceContext);
        ret.msg = this.msg;
        ret.isError = this.isError;
        return ret;
    }

    public boolean match(Shadow shadow, World world) {
        if (super.match(shadow, world)) {
            Message message = new Message(this.msg, shadow.toString(), this.isError ? IMessage.ERROR : IMessage.WARNING, shadow.getSourceLocation(), null, new ISourceLocation[]{this.getSourceLocation()}, true, 0, -1, -1);
            world.getMessageHandler().handleMessage(message);
            if (world.getCrossReferenceHandler() != null) {
                world.getCrossReferenceHandler().addCrossReference(this.getSourceLocation(), shadow.getSourceLocation(), this.isError ? IRelationship.Kind.DECLARE_ERROR : IRelationship.Kind.DECLARE_WARNING, false);
            }
            if (world.getModel() != null) {
                AsmRelationshipProvider.getDefault().checkerMunger(world.getModel(), shadow, this);
            }
        }
        return false;
    }

    public int compareTo(Object other) {
        return 0;
    }

    public Collection getThrownExceptions() {
        return Collections.EMPTY_LIST;
    }

    public boolean mustCheckExceptions() {
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Checker)) {
            return false;
        }
        Checker o = (Checker)other;
        return o.isError == this.isError && (o.pointcut == null ? this.pointcut == null : o.pointcut.equals(this.pointcut)) && (o.getSourceLocation() == null ? this.getSourceLocation() == null : o.getSourceLocation().equals(this.getSourceLocation()));
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int result = 17;
            result = 37 * result + (this.isError ? 1 : 0);
            this.hashCode = result = 37 * result + (this.pointcut == null ? 0 : this.pointcut.hashCode());
        }
        return this.hashCode;
    }

    public boolean isError() {
        return this.isError;
    }

    public ResolvedType getResolvedDeclaringAspect() {
        return this.getDeclaringType();
    }
}

