/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.util.PartialOrder;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class ShadowMunger
implements PartialOrder.PartialComparable,
IHasPosition {
    protected Pointcut pointcut;
    protected int start;
    protected int end;
    protected ISourceContext sourceContext;
    private ISourceLocation sourceLocation;
    private String handle = null;
    private ResolvedType declaringType;
    public static final ShadowMunger[] NONE = new ShadowMunger[0];

    public ShadowMunger(Pointcut pointcut, int start, int end, ISourceContext sourceContext) {
        this.pointcut = pointcut;
        this.start = start;
        this.end = end;
        this.sourceContext = sourceContext;
    }

    public abstract ShadowMunger concretize(ResolvedType var1, World var2, PerClause var3);

    public abstract void specializeOn(Shadow var1);

    public abstract void implementOn(Shadow var1);

    public boolean match(Shadow shadow, World world) {
        return this.pointcut.match(shadow).maybeTrue();
    }

    public abstract ShadowMunger parameterizeWith(ResolvedType var1, Map var2);

    public int fallbackCompareTo(Object other) {
        return this.toString().compareTo(this.toString());
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public ISourceLocation getSourceLocation() {
        if (this.sourceLocation == null && this.sourceContext != null) {
            this.sourceLocation = this.sourceContext.makeSourceLocation(this);
        }
        return this.sourceLocation;
    }

    public String getHandle() {
        ISourceLocation sl;
        if (null == this.handle && (sl = this.getSourceLocation()) != null) {
            if (World.createInjarHierarchy) {
                this.createHierarchy();
            }
            IProgramElement ipe = AsmManager.getDefault().getHierarchy().findElementForSourceLine(sl);
            this.handle = AsmManager.getDefault().getHandleProvider().createHandleIdentifier(ipe);
        }
        return this.handle;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setDeclaringType(ResolvedType aType) {
        this.declaringType = aType;
    }

    public ResolvedType getDeclaringType() {
        return this.declaringType;
    }

    public abstract Collection getThrownExceptions();

    public abstract boolean mustCheckExceptions();

    public abstract ResolvedType getResolvedDeclaringAspect();

    public void createHierarchy() {
        IProgramElement errorNode;
        IProgramElement sourceFileNode = AsmManager.getDefault().getHierarchy().findElementForSourceLine(this.getSourceLocation());
        if (!sourceFileNode.getKind().equals(IProgramElement.Kind.FILE_JAVA)) {
            return;
        }
        String name = sourceFileNode.getName();
        sourceFileNode.setName(name + " (binary)");
        ResolvedType aspect = this.getResolvedDeclaringAspect();
        IProgramElement root = AsmManager.getDefault().getHierarchy().getRoot();
        if (aspect.getPackageName() != null) {
            IProgramElement pkgNode = AsmManager.getDefault().getHierarchy().findElementForLabel(root, IProgramElement.Kind.PACKAGE, aspect.getPackageName());
            if (pkgNode == null) {
                pkgNode = new ProgramElement(aspect.getPackageName(), IProgramElement.Kind.PACKAGE, new ArrayList());
                root.addChild(pkgNode);
            }
            pkgNode.addChild(sourceFileNode);
        } else {
            root.addChild(sourceFileNode);
        }
        if (sourceFileNode instanceof ProgramElement && (errorNode = (IProgramElement)sourceFileNode.getChildren().get(0)).getKind().equals(IProgramElement.Kind.ERROR)) {
            ((ProgramElement)sourceFileNode).removeChild(errorNode);
        }
        sourceFileNode.addChild(new ProgramElement("import declarations", IProgramElement.Kind.IMPORT_REFERENCE, null, 0, null, null));
        ProgramElement aspectNode = new ProgramElement(aspect.getSimpleName(), IProgramElement.Kind.ASPECT, aspect.getSourceLocation(), aspect.getModifiers(), null, null);
        sourceFileNode.addChild(aspectNode);
        this.addChildNodes((IProgramElement)aspectNode, aspect.getDeclaredPointcuts());
        this.addChildNodes((IProgramElement)aspectNode, aspect.getDeclaredAdvice());
        this.addChildNodes((IProgramElement)aspectNode, aspect.getDeclares());
    }

    private void addChildNodes(IProgramElement parent, ResolvedMember[] children) {
        for (int i = 0; i < children.length; ++i) {
            ResolvedMember pcd = children[i];
            if (!(pcd instanceof ResolvedPointcutDefinition)) continue;
            ResolvedPointcutDefinition rpcd = (ResolvedPointcutDefinition)pcd;
            parent.addChild(new ProgramElement(pcd.getName(), IProgramElement.Kind.POINTCUT, rpcd.getPointcut().getSourceLocation(), pcd.getModifiers(), null, Collections.EMPTY_LIST));
        }
    }

    private void addChildNodes(IProgramElement parent, Collection children) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof DeclareErrorOrWarning) {
                DeclareErrorOrWarning decl = (DeclareErrorOrWarning)element;
                ProgramElement deowNode = new ProgramElement(decl.isError() ? "declare error" : "declare warning", decl.isError() ? IProgramElement.Kind.DECLARE_ERROR : IProgramElement.Kind.DECLARE_WARNING, this.getSourceLocation(), this.getDeclaringType().getModifiers(), null, null);
                deowNode.setDetails("\"" + this.genDeclareMessage(decl.getMessage()) + "\"");
                parent.addChild(deowNode);
                continue;
            }
            if (!(element instanceof BcelAdvice)) continue;
            BcelAdvice advice = (BcelAdvice)element;
            parent.addChild(new ProgramElement(advice.kind.getName(), IProgramElement.Kind.ADVICE, this.getSourceLocation(), advice.signature.getModifiers(), null, Collections.EMPTY_LIST));
        }
    }

    private String genDeclareMessage(String message) {
        int length = message.length();
        if (length < 18) {
            return message;
        }
        return message.substring(0, 17) + "..";
    }

    public abstract /* synthetic */ int compareTo(Object var1);
}

