/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.TypePattern;

class AnyWithAnnotationTypePattern
extends TypePattern {
    public AnyWithAnnotationTypePattern(AnnotationTypePattern atp) {
        super(false, false);
        this.annotationPattern = atp;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    protected boolean couldEverMatchSameTypesAs(TypePattern other) {
        return true;
    }

    protected boolean matchesExactly(ResolvedType type) {
        this.annotationPattern.resolve(type.getWorld());
        return this.annotationPattern.matches(type).alwaysTrue();
    }

    protected boolean matchesExactly(ResolvedType type, ResolvedType annotatedType) {
        this.annotationPattern.resolve(type.getWorld());
        return this.annotationPattern.matches(annotatedType).alwaysTrue();
    }

    public FuzzyBoolean matchesInstanceof(ResolvedType type) {
        if (Modifier.isFinal(type.getModifiers())) {
            return FuzzyBoolean.fromBoolean(this.matchesExactly(type));
        }
        return FuzzyBoolean.MAYBE;
    }

    public TypePattern parameterizeWith(Map typeVariableMap) {
        AnyWithAnnotationTypePattern ret = new AnyWithAnnotationTypePattern(this.annotationPattern.parameterizeWith(typeVariableMap));
        ret.copyLocationFrom(this);
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(10);
        this.annotationPattern.write(s);
        this.writeLocation(s);
    }

    public static TypePattern read(VersionedDataInputStream s, ISourceContext c) throws IOException {
        AnnotationTypePattern annPatt = AnnotationTypePattern.read(s, c);
        AnyWithAnnotationTypePattern ret = new AnyWithAnnotationTypePattern(annPatt);
        ret.readLocation(c, s);
        return ret;
    }

    protected boolean matchesSubtypes(ResolvedType type) {
        return true;
    }

    public boolean isStar() {
        return false;
    }

    public String toString() {
        return this.annotationPattern + " *";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnyWithAnnotationTypePattern)) {
            return false;
        }
        AnyWithAnnotationTypePattern awatp = (AnyWithAnnotationTypePattern)obj;
        return this.annotationPattern.equals(awatp.annotationPattern);
    }

    public int hashCode() {
        return this.annotationPattern.hashCode();
    }
}

