/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class LibraryDirective
implements Serializable {
    private static final String[] EMPTY_SET = new String[0];
    private final String[] m_includes;
    private final String[] m_groups;

    public LibraryDirective() {
        this(null, null);
    }

    public LibraryDirective(String[] includes, String[] groups) {
        this.m_includes = includes == null ? EMPTY_SET : includes;
        this.m_groups = groups == null ? EMPTY_SET : groups;
    }

    public boolean isEmpty() {
        int n = this.m_includes.length + this.m_groups.length;
        return n == 0;
    }

    public String[] getIncludes() {
        return this.m_includes;
    }

    public String[] getGroups() {
        return this.m_groups;
    }

    public File[] getOptionalExtensionDirectories(File base) throws IOException {
        if (base == null) {
            throw new NullPointerException("base");
        }
        String[] includes = this.getIncludes();
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < includes.length; ++i) {
            String path = includes[i];
            list.add(this.getDirectory(base, path));
        }
        return list.toArray(new File[0]);
    }

    private File getDirectory(File base, String path) throws IOException {
        File file = new File(path);
        if (file.isAbsolute()) {
            return this.verifyDirectory(file);
        }
        return this.verifyDirectory(new File(base, path));
    }

    private File verifyDirectory(File dir) throws IOException {
        if (dir.isDirectory()) {
            return dir.getCanonicalFile();
        }
        String error = "Path does not correspond to a directory: " + dir;
        throw new IOException(error);
    }
}

