/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import org.apache.avalon.composition.data.ContextDirective;
import org.apache.avalon.composition.data.DependencyDirective;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.data.StageDirective;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.logging.data.CategoriesDirective;

public class ComponentProfile
extends DeploymentProfile {
    private CategoriesDirective m_categories;
    private int m_collection;
    private String m_classname;
    private Parameters m_parameters;
    private Configuration m_configuration;
    private ContextDirective m_context;
    private DependencyDirective[] m_dependencies;
    private StageDirective[] m_stages;
    private Mode m_mode;

    public ComponentProfile(String name, String classname) {
        this(name, -1, -1, classname, null, null, null, null, null, null, Mode.IMPLICIT);
    }

    public ComponentProfile(String name, ComponentProfile template) {
        this(name, template.getActivationDirective(), template.getCollectionPolicy(), template.m_classname, template.m_categories, template.m_context, template.m_dependencies, template.m_stages, template.m_parameters, template.m_configuration, Mode.EXPLICIT);
    }

    public ComponentProfile(String name, int activation, int collection, String classname, CategoriesDirective categories, ContextDirective context, DependencyDirective[] dependencies, StageDirective[] stages, Parameters parameters, Configuration config, Mode mode) {
        super(name, activation, mode, categories);
        if (null == classname) {
            throw new NullPointerException("classname");
        }
        this.m_collection = collection;
        this.m_classname = classname;
        this.m_categories = categories;
        this.m_context = context;
        this.m_parameters = parameters;
        this.m_configuration = config;
        this.m_dependencies = null == dependencies ? new DependencyDirective[0] : dependencies;
        this.m_stages = null == stages ? new StageDirective[0] : stages;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public int getCollectionPolicy() {
        return this.m_collection;
    }

    public ContextDirective getContext() {
        return this.m_context;
    }

    public DependencyDirective[] getDependencyDirectives() {
        return this.m_dependencies;
    }

    public DependencyDirective getDependencyDirective(String key) {
        DependencyDirective[] directives = this.getDependencyDirectives();
        for (int i = 0; i < directives.length; ++i) {
            DependencyDirective directive = directives[i];
            if (!directive.getKey().equals(key)) continue;
            return directive;
        }
        return null;
    }

    public StageDirective[] getStageDirectives() {
        return this.m_stages;
    }

    public StageDirective getStageDirective(String key) {
        StageDirective[] directives = this.getStageDirectives();
        for (int i = 0; i < directives.length; ++i) {
            StageDirective directive = directives[i];
            if (!directive.getKey().equals(key)) continue;
            return directive;
        }
        return null;
    }

    public Parameters getParameters() {
        return this.m_parameters;
    }

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public String toString() {
        return "[" + this.getName() + "]";
    }
}

