/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import java.util.ArrayList;
import org.apache.avalon.composition.data.ClassLoaderDirective;
import org.apache.avalon.composition.data.ClasspathDirective;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.LibraryDirective;
import org.apache.avalon.composition.data.Mode;
import org.apache.avalon.composition.data.ServiceDirective;
import org.apache.avalon.logging.data.CategoriesDirective;

public class ContainmentProfile
extends DeploymentProfile {
    public static final String DELIMITER = "/";
    private static final ServiceDirective[] EMPTY_SERVICES = new ServiceDirective[0];
    private static final DeploymentProfile[] EMPTY_PROFILES = new DeploymentProfile[0];
    private static final ClassLoaderDirective EMPTY_CLASSLOADER = new ClassLoaderDirective(new LibraryDirective(), new ClasspathDirective());
    private ClassLoaderDirective m_classloader;
    private final ServiceDirective[] m_export;
    private final DeploymentProfile[] m_profiles;

    public ContainmentProfile() {
        this("container", null, null, null, null);
    }

    public ContainmentProfile(String name, ClassLoaderDirective classloader, ServiceDirective[] exports, CategoriesDirective categories, DeploymentProfile[] profiles) {
        super(name, 1, Mode.EXPLICIT, categories);
        this.m_classloader = classloader;
        this.m_profiles = profiles;
        this.m_export = exports;
    }

    public ClassLoaderDirective getClassLoaderDirective() {
        if (this.m_classloader == null) {
            return EMPTY_CLASSLOADER;
        }
        return this.m_classloader;
    }

    public ServiceDirective[] getExportDirectives() {
        if (this.m_export == null) {
            return EMPTY_SERVICES;
        }
        return this.m_export;
    }

    public ServiceDirective getExportDirective(Class clazz) {
        String classname = clazz.getName();
        ServiceDirective[] services = this.getExportDirectives();
        for (int i = 0; i < services.length; ++i) {
            ServiceDirective virtual = services[i];
            if (!virtual.getReference().getClassname().equals(classname)) continue;
            return virtual;
        }
        return null;
    }

    public DeploymentProfile[] getProfiles() {
        if (this.m_profiles == null) {
            return EMPTY_PROFILES;
        }
        return this.m_profiles;
    }

    public DeploymentProfile[] getProfiles(Mode mode) {
        DeploymentProfile[] profiles = this.getProfiles();
        return this.selectProfileByMode(profiles, mode);
    }

    private DeploymentProfile[] selectProfileByMode(DeploymentProfile[] profiles, Mode mode) {
        ArrayList<DeploymentProfile> list = new ArrayList<DeploymentProfile>();
        for (int i = 0; i < profiles.length; ++i) {
            DeploymentProfile profile = profiles[i];
            if (!profile.getMode().equals(mode)) continue;
            list.add(profile);
        }
        return list.toArray(new DeploymentProfile[0]);
    }
}

