/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;

public final class PermissionDirective
implements Serializable {
    private Permission m_permission;

    public PermissionDirective(String classname, String name, String action) throws InstantiationException, IllegalAccessException, ClassNotFoundException, ClassCastException, InvocationTargetException {
        if (classname == null) {
            throw new NullPointerException("classname");
        }
        ClassLoader trustedClassloader = this.getClass().getClassLoader();
        Class<?> clazz = trustedClassloader.loadClass(classname);
        Constructor[] constructors = clazz.getConstructors();
        if (name == null) {
            this.m_permission = (Permission)clazz.newInstance();
        } else if (action == null) {
            Constructor cons = this.getConstructor(constructors, 1);
            Object[] arg = new Object[]{name};
            this.m_permission = (Permission)cons.newInstance(arg);
        } else {
            Constructor cons = this.getConstructor(constructors, 2);
            Object[] args = new Object[]{name, action};
            this.m_permission = (Permission)cons.newInstance(args);
        }
    }

    public Permission getPermission() {
        return this.m_permission;
    }

    private Constructor getConstructor(Constructor[] constructors, int noOfParameters) {
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] params = constructors[i].getParameterTypes();
            if (params.length != noOfParameters) continue;
            return constructors[i];
        }
        return null;
    }
}

