/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data.builder;

import java.io.InputStream;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.data.ProfilePackage;
import org.apache.avalon.composition.data.builder.ProfilePackageCreator;
import org.apache.avalon.composition.data.builder.SerializedProfilePackageCreator;
import org.apache.avalon.composition.data.builder.XMLProfilePackageCreator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.meta.ConfigurationBuilder;
import org.xml.sax.InputSource;

public final class ProfilePackageBuilder
implements ProfilePackageCreator {
    private XMLProfilePackageCreator m_xml = new XMLProfilePackageCreator();
    private final SerializedProfilePackageCreator m_serial = new SerializedProfilePackageCreator();

    public ProfilePackage createProfilePackage(String name, Class clazz) throws Exception {
        ProfilePackage profiles = this.m_serial.createProfilePackage(name, clazz);
        if (profiles != null) {
            return profiles;
        }
        String classname = clazz.getName();
        String xprofile = classname.replace('.', '/') + ".xprofile";
        InputStream stream = clazz.getClassLoader().getResourceAsStream(xprofile);
        if (stream == null) {
            DeploymentProfile profile = new DeploymentProfile(name, classname);
            return new ProfilePackage(new DeploymentProfile[]{profile});
        }
        return this.buildFromXMLDescriptor(name, classname, stream);
    }

    private ProfilePackage buildFromSerDescriptor(InputStream input) throws Exception {
        return this.m_serial.createProfilePackage(input);
    }

    private ProfilePackage buildFromXMLDescriptor(String name, String classname, InputStream input) throws Exception {
        InputSource source = new InputSource(input);
        Configuration config = ConfigurationBuilder.build((InputSource)source);
        return this.m_xml.createProfilePackage(name, classname, config);
    }
}

