/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.avalon.composition.data.ConstructorDirective;
import org.apache.avalon.composition.data.Parameter;
import org.apache.avalon.composition.model.DeploymentContext;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.impl.DefaultEntryModel;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.meta.info.EntryDescriptor;

public class DefaultConstructorModel
extends DefaultEntryModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultConstructorModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultConstructorModel = DefaultConstructorModel.class$("org.apache.avalon.composition.model.impl.DefaultConstructorModel")) : class$org$apache$avalon$composition$model$impl$DefaultConstructorModel));
    private final ConstructorDirective m_directive;
    private final EntryDescriptor m_descriptor;
    private final DeploymentContext m_context;
    private final Map m_map;
    private Object m_value;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultConstructorModel;
    static /* synthetic */ Class class$java$lang$String;

    public DefaultConstructorModel(EntryDescriptor descriptor, ConstructorDirective directive, DeploymentContext context, Map map) throws ModelException {
        super(descriptor);
        if (directive == null) {
            throw new NullPointerException("directive");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.m_descriptor = descriptor;
        this.m_directive = directive;
        this.m_context = context;
        this.m_map = map;
        this.validate();
    }

    private void validate() throws ModelException {
        String descriptorClassName = this.m_descriptor.getClassname();
        String directiveClassName = this.m_directive.getClassname();
        this.validatePair(descriptorClassName, directiveClassName);
        Parameter[] params = this.m_directive.getParameters();
    }

    private void validatePair(String descriptorClass, String directiveClass) throws ModelException {
        String key = this.m_descriptor.getKey();
        ClassLoader loader = this.m_context.getClassLoader();
        Class<?> target = null;
        try {
            target = loader.loadClass(descriptorClass);
        }
        catch (ClassNotFoundException e) {
            String error = REZ.getString("constructor.descriptor.unknown.error", (Object)key, (Object)descriptorClass);
            throw new ModelException(error);
        }
        catch (Throwable e) {
            String error = REZ.getString("constructor.descriptor.load.error", (Object)key, (Object)descriptorClass);
            throw new ModelException(error, e);
        }
        Class<?> source = null;
        try {
            source = loader.loadClass(directiveClass);
        }
        catch (ClassNotFoundException e) {
            String error = REZ.getString("constructor.directive.unknown.error", (Object)key, (Object)directiveClass);
            throw new ModelException(error);
        }
        catch (Throwable e) {
            String error = REZ.getString("constructor.directive.load.error", (Object)key, (Object)directiveClass);
            throw new ModelException(error, e);
        }
        if (!target.isAssignableFrom(source)) {
            String error = REZ.getString("constructor.invalid-model.error", (Object)key, (Object)descriptorClass, (Object)directiveClass);
            throw new ModelException(error);
        }
    }

    public Object getValue() throws ModelException {
        if (this.m_value != null) {
            return this.m_value;
        }
        String target = this.m_descriptor.getKey();
        Object object = null;
        try {
            ClassLoader loader = this.m_context.getClassLoader();
            String classname = this.m_directive.getClassname();
            String argument = this.m_directive.getArgument();
            Parameter[] params = this.m_directive.getParameters();
            Class clazz = this.getParameterClass(classname, loader);
            object = this.getValue(loader, clazz, argument, params);
        }
        catch (Throwable e) {
            String error = "Cannot establish a constructed context entry for the key " + target + " due to a runtime failure.";
            throw new ModelException(error, e);
        }
        if (!this.m_descriptor.isVolatile()) {
            this.m_value = object;
        }
        return object;
    }

    public Object getValue(Parameter p) throws ModelException {
        ClassLoader loader = this.m_context.getClassLoader();
        String classname = p.getClassname();
        String argument = p.getArgument();
        Parameter[] params = p.getParameters();
        Class clazz = this.getParameterClass(classname, loader);
        return this.getValue(loader, clazz, argument, params);
    }

    public Object getValue(ClassLoader loader, Class clazz, String argument, Parameter[] parameters) throws ModelException {
        if (parameters.length == 0) {
            if (argument == null) {
                return this.getNullArgumentConstructorValue(clazz);
            }
            return this.getSingleArgumentConstructorValue(loader, clazz, argument);
        }
        return this.getMultiArgumentConstructorValue(loader, clazz, parameters);
    }

    private Object getMultiArgumentConstructorValue(ClassLoader classLoader, Class clazz, Parameter[] parameters) throws ModelException {
        String error;
        if (parameters.length == 0) {
            try {
                return clazz.newInstance();
            }
            catch (InstantiationException e) {
                String error2 = "Unable to instantiate instance of class: " + clazz.getName();
                throw new ModelException(error2, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                String error3 = "Cannot access null constructor for the class: '" + clazz.getName() + "'.";
                throw new ModelException(error3, (Throwable)e);
            }
        }
        Class[] params = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String classname = parameters[i].getClassname();
            try {
                params[i] = classLoader.loadClass(classname);
                continue;
            }
            catch (Throwable e) {
                String error4 = "Unable to resolve sub-parameter class: " + classname + " for the parameter " + clazz.getName();
                throw new ModelException(error4, e);
            }
        }
        Object[] values = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            String classname = p.getClassname();
            try {
                values[i] = this.getValue(p);
                continue;
            }
            catch (Throwable e) {
                String error5 = "Unable to instantiate sub-parameter for value: " + classname + " inside the parameter " + clazz.getName();
                throw new ModelException(error5, e);
            }
        }
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(params);
        }
        catch (NoSuchMethodException e) {
            error = "Supplied parameters for " + clazz.getName() + " do not match the available class constructors.";
            throw new ModelException(error, (Throwable)e);
        }
        try {
            return constructor.newInstance(values);
        }
        catch (InstantiationException e) {
            error = "Unable to instantiate an instance of a multi-parameter constructor for class: '" + clazz.getName() + "'.";
            throw new ModelException(error, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            error = "Cannot access multi-parameter constructor for the class: '" + clazz.getName() + "'.";
            throw new ModelException(error, (Throwable)e);
        }
        catch (Throwable e) {
            error = "Unexpected error while attmpting to instantiate a multi-parameter constructor for the class: '" + clazz.getName() + "'.";
            throw new ModelException(error, e);
        }
    }

    private Object getNullArgumentConstructorValue(Class clazz) throws ModelException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            String error = "Unable to instantiate instance of class: " + clazz.getName();
            throw new ModelException(error, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String error = "Cannot access null parameter constructor for the class: '" + clazz.getName() + "'.";
            throw new ModelException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = "Unexpected exception while creating the class: '" + clazz.getName() + "'.";
            throw new ModelException(error, e);
        }
    }

    private Object getSingleArgumentConstructorValue(ClassLoader classLoader, Class clazz, String argument) throws ModelException {
        if (argument.startsWith("${")) {
            if (argument.endsWith("}")) {
                String key = argument.substring(2, argument.length() - 1);
                Object value = null;
                try {
                    return this.m_context.resolve(key);
                }
                catch (ContextException e) {
                    value = this.m_map.get(key);
                    if (value != null) {
                        return value;
                    }
                    String error = "Unresolvable primative context value: '" + key + "'.";
                    throw new ModelException(error);
                }
            }
            String error = "Illegal format for context reference: '" + argument + "'.";
            throw new ModelException(error);
        }
        try {
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultConstructorModel.class$("java.lang.String")) : class$java$lang$String};
            Constructor constructor = clazz.getConstructor(params);
            Object[] values = new Object[]{argument};
            return constructor.newInstance(values);
        }
        catch (NoSuchMethodException e) {
            String error = "Class: '" + clazz.getName() + "' does not implement a single string argument constructor.";
            throw new ModelException(error);
        }
        catch (InstantiationException e) {
            String error = "Unable to instantiate instance of class: " + clazz.getName() + " with the single argument: '" + argument + "'";
            throw new ModelException(error, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            String error = "Cannot access single string parameter constructor for the class: '" + clazz.getName() + "'.";
            throw new ModelException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = "Unexpected exception while creating a single string parameter value for the class: '" + clazz.getName() + "'.";
            throw new ModelException(error, e);
        }
    }

    Class getParameterClass(String classname, ClassLoader classLoader) throws ModelException {
        try {
            return classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            if (classname.equals("int")) {
                return Integer.TYPE;
            }
            if (classname.equals("short")) {
                return Short.TYPE;
            }
            if (classname.equals("long")) {
                return Long.TYPE;
            }
            if (classname.equals("byte")) {
                return Byte.TYPE;
            }
            if (classname.equals("double")) {
                return Double.TYPE;
            }
            if (classname.equals("byte")) {
                return Byte.TYPE;
            }
            if (classname.equals("float")) {
                return Float.TYPE;
            }
            if (classname.equals("char")) {
                return Character.TYPE;
            }
            if (classname.equals("char")) {
                return Character.TYPE;
            }
            if (classname.equals("boolean")) {
                return Boolean.TYPE;
            }
            throw new ModelException("Could not locate the parameter implemetation for class: '" + classname + "'.", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

