/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.composition.data.ConstructorDirective;
import org.apache.avalon.composition.data.ContextDirective;
import org.apache.avalon.composition.data.EntryDirective;
import org.apache.avalon.composition.data.ImportDirective;
import org.apache.avalon.composition.model.ContextModel;
import org.apache.avalon.composition.model.DeploymentContext;
import org.apache.avalon.composition.model.EntryModel;
import org.apache.avalon.composition.model.ModelException;
import org.apache.avalon.composition.model.impl.DefaultConstructorModel;
import org.apache.avalon.composition.model.impl.DefaultContext;
import org.apache.avalon.composition.model.impl.DefaultEntryModel;
import org.apache.avalon.composition.model.impl.DefaultImportModel;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.EntryDescriptor;

public class DefaultContextModel
extends AbstractLogEnabled
implements ContextModel {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultContextModel == null ? (class$org$apache$avalon$composition$model$impl$DefaultContextModel = DefaultContextModel.class$("org.apache.avalon.composition.model.impl.DefaultContextModel")) : class$org$apache$avalon$composition$model$impl$DefaultContextModel));
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$apache$avalon$composition$model$impl$DefaultContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultContext = DefaultContextModel.class$("org.apache.avalon.composition.model.impl.DefaultContext")) : class$org$apache$avalon$composition$model$impl$DefaultContext;
    private final ContextDescriptor m_descriptor;
    private final ContextDirective m_directive;
    private final DeploymentContext m_context;
    private final Class m_strategy;
    private final Map m_models = new Hashtable();
    private final Map m_map = new Hashtable();
    private final Context m_componentContext;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContextModel;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultContext;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Context;

    public DefaultContextModel(Logger logger, ContextDescriptor descriptor, ContextDirective directive, DeploymentContext context) throws ModelException {
        this.enableLogging(logger);
        this.m_descriptor = descriptor;
        this.m_directive = directive;
        this.m_context = context;
        ClassLoader classLoader = context.getClassLoader();
        this.m_strategy = this.loadStrategyClass(descriptor, classLoader);
        EntryDescriptor[] entries = descriptor.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            DefaultEntryModel model;
            String error;
            EntryDescriptor entry = entries[i];
            String key = entry.getKey();
            if (key.startsWith("urn:avalon:")) {
                try {
                    Object value = this.m_context.resolve(key);
                    this.m_map.put(key, value);
                    continue;
                }
                catch (ContextException e) {
                    error = REZ.getString("context.non-standard-avalon-key.error", (Object)key);
                    throw new ModelException(error);
                }
            }
            EntryDirective entryDirective = directive.getEntryDirective(key);
            if (entryDirective == null) {
                error = REZ.getString("context.missing-directive.error", (Object)key);
                throw new ModelException(error);
            }
            if (entryDirective instanceof ImportDirective) {
                ImportDirective importDirective = (ImportDirective)entryDirective;
                model = new DefaultImportModel(entry, importDirective, context, this.m_map);
                this.m_context.register((EntryModel)model);
                this.m_map.put(key, ((DefaultImportModel)model).getValue());
                continue;
            }
            if (entryDirective instanceof ConstructorDirective) {
                ConstructorDirective constructor = (ConstructorDirective)entryDirective;
                model = new DefaultConstructorModel(entry, constructor, context, this.m_map);
                this.m_context.register((EntryModel)model);
                this.m_map.put(key, ((DefaultConstructorModel)model).getValue());
                continue;
            }
            String modelClass = entryDirective.getClass().getName();
            String error2 = REZ.getString("context.unsupported-directive.error", (Object)key, (Object)modelClass);
            throw new ModelException(error2);
        }
        this.m_componentContext = this.createComponentContext(this.m_context, descriptor, directive);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("context: " + this.m_map);
        }
    }

    public Class getStrategyClass() {
        return this.m_strategy;
    }

    public Context getContext() {
        return this.m_componentContext;
    }

    private Class loadStrategyClass(ContextDescriptor descriptor, ClassLoader classloader) throws ModelException {
        String strategy = this.m_descriptor.getAttribute("urn:avalon:context.strategy", null);
        if (strategy != null) {
            try {
                Class<?> clazz = classloader.loadClass(strategy);
                if (this.getLogger().isDebugEnabled()) {
                    String message = REZ.getString("context.strategy.custom", (Object)strategy);
                    this.getLogger().debug(message);
                }
                return clazz;
            }
            catch (ClassNotFoundException e) {
                String error = REZ.getString("context.strategy.custom.missing.error", (Object)strategy);
                throw new ModelException(error);
            }
            catch (Throwable e) {
                String error = REZ.getString("context.strategy.custom.unexpected.error", (Object)strategy);
                throw new ModelException(error, e);
            }
        }
        try {
            Class<?> clazz = classloader.loadClass("org.apache.avalon.framework.context.Contextualizable");
            if (this.getLogger().isDebugEnabled()) {
                String message = REZ.getString("context.strategy.avalon");
                this.getLogger().debug(message);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            String error = REZ.getString("context.strategy.avalon.missing.error", (Object)"org.apache.avalon.framework.context.Contextualizable");
            throw new ModelException(error);
        }
        catch (Throwable e) {
            String error = REZ.getString("context.strategy.avalon.unexpected.error", (Object)"org.apache.avalon.framework.context.Contextualizable");
            throw new ModelException(error, e);
        }
    }

    private Context createComponentContext(DeploymentContext context, ContextDescriptor descriptor, ContextDirective directive) throws ModelException {
        ClassLoader classLoader = context.getClassLoader();
        Class clazz = this.loadContextClass(directive, classLoader);
        this.validateCastingConstraint(descriptor, classLoader, clazz);
        DefaultContext base = new DefaultContext(context);
        if (clazz.equals(class$org$apache$avalon$composition$model$impl$DefaultContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultContext = DefaultContextModel.class$("org.apache.avalon.composition.model.impl.DefaultContext")) : class$org$apache$avalon$composition$model$impl$DefaultContext)) {
            return base;
        }
        try {
            Constructor constructor = clazz.getConstructor(class$org$apache$avalon$framework$context$Context == null ? (class$org$apache$avalon$framework$context$Context = DefaultContextModel.class$("org.apache.avalon.framework.context.Context")) : class$org$apache$avalon$framework$context$Context);
            return (Context)constructor.newInstance(base);
        }
        catch (NoSuchMethodException e) {
            String error = REZ.getString("context.non-compliance-constructor.error", (Object)clazz.getName());
            throw new ModelException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = REZ.getString("context.custom-unexpected.error", (Object)clazz.getName());
            throw new ModelException(error, e);
        }
    }

    private Class loadContextClass(ContextDirective directive, ClassLoader classLoader) throws ModelException {
        if (directive == null) {
            return DEFAULT_CONTEXT_CLASS;
        }
        String classname = this.m_directive.getClassname();
        if (classname == null) {
            return DEFAULT_CONTEXT_CLASS;
        }
        try {
            return classLoader.loadClass(classname);
        }
        catch (Throwable e) {
            String error = "Cannot load custom context implementation class: " + classname;
            throw new ModelException(error, e);
        }
    }

    private void validateCastingConstraint(ContextDescriptor descriptor, ClassLoader classLoader, Class clazz) throws ModelException {
        Class<?> castingClass = null;
        String castingClassName = descriptor.getContextInterfaceClassname();
        if (castingClassName != null) {
            try {
                castingClass = classLoader.loadClass(castingClassName);
            }
            catch (Throwable e) {
                String error = "Cannot load custom context interface class: " + castingClassName;
                throw new ModelException(error, e);
            }
        }
        try {
            castingClass = classLoader.loadClass((class$org$apache$avalon$framework$context$Context == null ? (class$org$apache$avalon$framework$context$Context = DefaultContextModel.class$("org.apache.avalon.framework.context.Context")) : class$org$apache$avalon$framework$context$Context).getName());
        }
        catch (Throwable e) {
            String error = "Cannot load standard Avalon context interface class: " + (class$org$apache$avalon$framework$context$Context == null ? (class$org$apache$avalon$framework$context$Context = DefaultContextModel.class$("org.apache.avalon.framework.context.Context")) : class$org$apache$avalon$framework$context$Context).getName();
            throw new ModelException(error, e);
        }
        if (!castingClass.isAssignableFrom(clazz)) {
            String error = "Supplied context implementation class: " + clazz.getName() + " does not implement the interface: " + castingClass.getName() + ".";
            throw new ModelException(error);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

