/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.data.builder;

import java.util.ArrayList;
import org.apache.avalon.composition.data.BlockCompositionDirective;
import org.apache.avalon.composition.data.BlockIncludeDirective;
import org.apache.avalon.composition.data.CategoriesDirective;
import org.apache.avalon.composition.data.ClassLoaderDirective;
import org.apache.avalon.composition.data.ClasspathDirective;
import org.apache.avalon.composition.data.ContainmentProfile;
import org.apache.avalon.composition.data.FilesetDirective;
import org.apache.avalon.composition.data.IncludeDirective;
import org.apache.avalon.composition.data.LibraryDirective;
import org.apache.avalon.composition.data.MetaDataException;
import org.apache.avalon.composition.data.NamedDeploymentProfile;
import org.apache.avalon.composition.data.Profile;
import org.apache.avalon.composition.data.RepositoryDirective;
import org.apache.avalon.composition.data.ResourceDirective;
import org.apache.avalon.composition.data.ServiceDirective;
import org.apache.avalon.composition.data.TargetDirective;
import org.apache.avalon.composition.data.Targets;
import org.apache.avalon.composition.data.builder.XMLDeploymentProfileCreator;
import org.apache.avalon.composition.data.builder.XMLProfileCreator;
import org.apache.avalon.composition.data.builder.XMLTargetsCreator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.builder.XMLTypeCreator;
import org.apache.excalibur.configuration.ConfigurationUtil;

public class XMLContainmentProfileCreator
extends XMLProfileCreator {
    private static final XMLTypeCreator TYPE_CREATOR = new XMLTypeCreator();
    private static final XMLDeploymentProfileCreator DEPLOYMENT_CREATOR = new XMLDeploymentProfileCreator();
    private static final XMLTargetsCreator TARGETS_CREATOR = new XMLTargetsCreator();

    public ContainmentProfile createContainmentProfile(Configuration config) throws Exception {
        String name = null;
        name = config.getName().equals("block") ? config.getChild("info").getChild("name").getValue("untitled") : this.getName(null, config, "untitled");
        ServiceDirective[] exports = this.createServiceDirectives(config.getChild("services", false));
        Configuration implementation = config;
        if (config.getChild("implementation", false) != null) {
            implementation = config.getChild("implementation");
        }
        ClassLoaderDirective classloader = null;
        if (implementation.getChild("engine", false) != null) {
            Configuration engine = implementation.getChild("engine");
            String msg = ConfigurationUtil.list((Configuration)engine);
            System.out.println("please replace 'engine' with 'classloader'\n" + msg);
            classloader = this.createClassLoaderDirective(engine);
        } else {
            classloader = this.createClassLoaderDirective(implementation.getChild("classloader", false));
        }
        CategoriesDirective categories = this.getCategoriesDirective(implementation.getChild("categories", false), name);
        Profile[] profiles = this.createProfiles(implementation);
        return new ContainmentProfile(name, classloader, exports, categories, profiles);
    }

    private ClassLoaderDirective createClassLoaderDirective(Configuration config) throws ConfigurationException {
        if (config == null) {
            return null;
        }
        LibraryDirective library = this.createLibraryDirective(config.getChild("library", false));
        ClasspathDirective classpath = this.createClasspathDirective(config.getChild("classpath", false));
        return new ClassLoaderDirective(library, classpath);
    }

    private ClasspathDirective createClasspathDirective(Configuration config) throws ConfigurationException {
        if (config == null) {
            return null;
        }
        FilesetDirective[] filesets = this.createFilesetDirectives(config);
        RepositoryDirective[] repositories = this.createRepositoryDirectives(config);
        return new ClasspathDirective(filesets, repositories);
    }

    private LibraryDirective createLibraryDirective(Configuration config) throws ConfigurationException {
        if (config == null) {
            return null;
        }
        Configuration[] includes = config.getChildren("include");
        String[] inc = new String[includes.length];
        for (int i = 0; i < includes.length; ++i) {
            inc[i] = this.getIncludeValue(includes[i]);
        }
        Configuration[] groups = config.getChildren("group");
        String[] grp = new String[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            grp[i] = groups[i].getValue();
        }
        return new LibraryDirective(inc, grp);
    }

    private RepositoryDirective[] createRepositoryDirectives(Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config");
        }
        Configuration[] children = config.getChildren("repository");
        RepositoryDirective[] repositories = new RepositoryDirective[children.length];
        for (int i = 0; i < children.length; ++i) {
            ResourceDirective[] resources = this.createResourceDirectives(children[i]);
            repositories[i] = new RepositoryDirective(resources);
        }
        return repositories;
    }

    private ResourceDirective[] createResourceDirectives(Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config");
        }
        ArrayList<ResourceDirective> res = new ArrayList<ResourceDirective>();
        Configuration[] resources = config.getChildren("resource");
        for (int i = 0; i < resources.length; ++i) {
            Configuration resource = resources[i];
            res.add(this.createResourceDirective(resource));
        }
        return res.toArray(new ResourceDirective[0]);
    }

    private ResourceDirective createResourceDirective(Configuration config) throws ConfigurationException {
        String id = config.getAttribute("id");
        String version = config.getAttribute("version", null);
        String type = config.getAttribute("type", null);
        if (type == null) {
            return ResourceDirective.createResourceDirective((String)id, (String)version);
        }
        return ResourceDirective.createResourceDirective((String)id, (String)version, (String)type);
    }

    private FilesetDirective[] createFilesetDirectives(Configuration config) throws ConfigurationException {
        ArrayList<FilesetDirective> list = new ArrayList<FilesetDirective>();
        Configuration[] children = config.getChildren("fileset");
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            list.add(this.createFilesetDirective(child));
        }
        return list.toArray(new FilesetDirective[0]);
    }

    public FilesetDirective createFilesetDirective(Configuration config) throws ConfigurationException {
        String base = config.getAttribute("dir", ".");
        IncludeDirective[] includes = this.createIncludeDirectives(config);
        return new FilesetDirective(base, includes);
    }

    protected IncludeDirective[] createIncludeDirectives(Configuration config) throws ConfigurationException {
        if (config == null) {
            return new IncludeDirective[0];
        }
        ArrayList<IncludeDirective> list = new ArrayList<IncludeDirective>();
        Configuration[] children = config.getChildren("include");
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            list.add(this.createIncludeDirective(child));
        }
        return list.toArray(new IncludeDirective[0]);
    }

    protected IncludeDirective createIncludeDirective(Configuration config) throws ConfigurationException {
        return new IncludeDirective(this.getIncludeValue(config));
    }

    private String getIncludeValue(Configuration config) throws ConfigurationException {
        if (config.getAttribute("path", null) != null) {
            return config.getAttribute("path");
        }
        if (config.getAttribute("name", null) != null) {
            return config.getAttribute("name");
        }
        return config.getValue();
    }

    protected Profile[] createProfiles(Configuration config) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Configuration[] children = config.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            if (child.getName().equals("classloader")) continue;
            if (child.getName().equals("container")) {
                list.add(this.createContainmentProfile(child));
                continue;
            }
            if (child.getName().equals("component")) {
                if (child.getAttribute("profile", null) != null) {
                    list.add(this.createNamedDeploymentProfile(child));
                    continue;
                }
                list.add(DEPLOYMENT_CREATOR.createDeploymentProfile(child));
                continue;
            }
            if (!child.getName().equals("include")) continue;
            list.add(this.createFromInclude(child));
        }
        return list.toArray(new Profile[0]);
    }

    private NamedDeploymentProfile createNamedDeploymentProfile(Configuration config) throws Exception {
        String name = config.getAttribute("name");
        String classname = config.getAttribute("class");
        String key = config.getAttribute("profile");
        boolean activation = this.getActivationPolicy(config);
        return new NamedDeploymentProfile(name, classname, key, activation);
    }

    public ServiceDirective[] createServiceDirectives(Configuration config) throws MetaDataException {
        if (config == null) {
            return new ServiceDirective[0];
        }
        Configuration[] children = config.getChildren("service");
        ArrayList<ServiceDirective> list = new ArrayList<ServiceDirective>();
        for (int i = 0; i < children.length; ++i) {
            list.add(this.createServiceDirective(children[i]));
        }
        return list.toArray(new ServiceDirective[0]);
    }

    private ServiceDirective createServiceDirective(Configuration config) throws MetaDataException {
        try {
            ServiceDescriptor service = TYPE_CREATOR.buildService(config);
            Configuration source = config.getChild("source", false);
            if (source == null) {
                String error = "Service configuration must contain a source directive.";
                throw new MetaDataException("Service configuration must contain a source directive.");
            }
            String path = source.getValue();
            return new ServiceDirective(service, path);
        }
        catch (Throwable ce) {
            String error = "Invalid service declaration in block specification:\n" + ConfigurationUtil.list((Configuration)config);
            throw new MetaDataException(error, ce);
        }
    }

    private Profile createFromInclude(Configuration config) throws MetaDataException, ConfigurationException {
        String name = this.getBlockIncludeName(config);
        if (config.getAttribute("id", null) != null) {
            ResourceDirective resource = this.createResourceDirective(config);
            TargetDirective[] targets = this.createTargetDirectives(config);
            return new BlockCompositionDirective(name, resource, targets);
        }
        String path = this.getBlockIncludePath(config);
        return new BlockIncludeDirective(name, path);
    }

    private TargetDirective[] createTargetDirectives(Configuration config) throws MetaDataException {
        try {
            Targets targets = TARGETS_CREATOR.createTargets(config);
            return targets.getTargets();
        }
        catch (Throwable e) {
            String error = "Unexpected error while attempting to build target directives.";
            throw new MetaDataException("Unexpected error while attempting to build target directives.", e);
        }
    }

    private String getBlockIncludeName(Configuration config) throws MetaDataException {
        try {
            return config.getAttribute("name");
        }
        catch (ConfigurationException e) {
            String error = "Missing 'name' attribute in the block include statement:\n" + ConfigurationUtil.list((Configuration)config);
            throw new MetaDataException(error, (Throwable)e);
        }
    }

    private String getBlockIncludePath(Configuration config) throws MetaDataException {
        try {
            Configuration source = config.getChild("source", false);
            if (null == source) {
                String error = "Missing 'source' element in the block include statement:\n" + ConfigurationUtil.list((Configuration)config);
                throw new MetaDataException(error);
            }
            return source.getValue();
        }
        catch (ConfigurationException e) {
            String error = "Missing source value in the block include statement:\n" + ConfigurationUtil.list((Configuration)config);
            throw new MetaDataException(error, (Throwable)e);
        }
    }
}

