/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.model.impl;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.composition.data.DeploymentProfile;
import org.apache.avalon.composition.model.ContainmentContext;
import org.apache.avalon.composition.model.DeploymentContext;
import org.apache.avalon.composition.model.EntryModel;
import org.apache.avalon.composition.model.ModelRuntimeException;
import org.apache.avalon.composition.model.SystemContext;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.meta.info.Type;

public class DefaultDeploymentContext
extends DefaultContext
implements DeploymentContext {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$composition$model$impl$DefaultDeploymentContext == null ? (class$org$apache$avalon$composition$model$impl$DefaultDeploymentContext = DefaultDeploymentContext.class$("org.apache.avalon.composition.model.impl.DefaultDeploymentContext")) : class$org$apache$avalon$composition$model$impl$DefaultDeploymentContext));
    private final String m_name;
    private final ContainmentContext m_context;
    private final DeploymentProfile m_profile;
    private final Type m_type;
    private final Class m_class;
    private final File m_home;
    private final File m_temp;
    private final Logger m_logger;
    private final String m_partition;
    private final Map m_map = new Hashtable();
    static /* synthetic */ Class class$org$apache$avalon$composition$model$impl$DefaultDeploymentContext;

    public DefaultDeploymentContext(Logger logger, String name, ContainmentContext context, DeploymentProfile profile, Type type, Class clazz, File home, File temp, String partition) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (logger == null) {
            throw new NullPointerException("logger");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (profile == null) {
            throw new NullPointerException("profile");
        }
        if (partition == null) {
            throw new NullPointerException("partition");
        }
        if (home.exists() && !home.isDirectory()) {
            String error = REZ.getString("deployment.context.home.not-a-directory.error", (Object)home);
            throw new IllegalArgumentException(error);
        }
        if (temp.exists() && !temp.isDirectory()) {
            String error = REZ.getString("deployment.context.temp.not-a-directory.error", (Object)temp);
            throw new IllegalArgumentException(error);
        }
        this.m_name = name;
        this.m_home = home;
        this.m_temp = temp;
        this.m_context = context;
        this.m_type = type;
        this.m_logger = logger;
        this.m_profile = profile;
        this.m_partition = partition;
        this.m_class = clazz;
    }

    public String getPartitionName() {
        return this.m_partition;
    }

    public String getName() {
        return this.m_name;
    }

    public SystemContext getSystemContext() {
        return this.m_context.getSystemContext();
    }

    public ContainmentContext getContainmentContext() {
        return this.m_context;
    }

    public File getHomeDirectory() {
        return this.m_home;
    }

    public File getTempDirectory() {
        return this.m_temp;
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    public DeploymentProfile getProfile() {
        return this.m_profile;
    }

    public Type getType() {
        return this.m_type;
    }

    public Class getDeploymentClass() {
        return this.m_class;
    }

    public ClassLoader getClassLoader() {
        return this.m_context.getClassLoader();
    }

    public void register(EntryModel model) {
        String key = model.getKey();
        if (this.m_map.get(key) != null) {
            String error = REZ.getString("deployment.registration.override.error", (Object)key);
            throw new IllegalArgumentException(error);
        }
        this.m_map.put(key, model);
    }

    public Object resolve(String alias) throws ContextException {
        if (alias == null) {
            throw new NullPointerException("alias");
        }
        String key = alias;
        EntryDescriptor entry = this.getType().getContext().getEntry(alias);
        if (entry != null) {
            key = entry.getKey();
        }
        if (key.equals("urn:avalon:name")) {
            return this.getName();
        }
        if (key.equals("urn:avalon:partition")) {
            return this.getPartitionName();
        }
        if (key.equals("urn:avalon:classloader")) {
            return this.getClassLoader();
        }
        if (key.equals("urn:avalon:home")) {
            return this.getHomeDirectory();
        }
        if (key.equals("urn:avalon:temp")) {
            return this.getTempDirectory();
        }
        Object object = this.m_map.get(key);
        if (null != object) {
            String classname = object.getClass().getName();
            try {
                return ((EntryModel)object).getValue();
            }
            catch (Throwable e) {
                String error = REZ.getString("deployment.context.runtime-get", (Object)key, (Object)classname);
                throw new ModelRuntimeException(error, e);
            }
        }
        String error = REZ.getString("deployment.context.runtime-get", (Object)key);
        throw new ModelRuntimeException(error);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

