/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.composition.util;

import java.io.File;
import java.net.URL;

public class StringHelper {
    private static final String USER_DIR = StringHelper.getUserDir();
    private static final String MERLIN_HOME = StringHelper.getMerlinHome();
    private static final String MERLIN_REPO_LOCAL = StringHelper.getRepositoryLocal();

    public static String toString(String name) {
        if (name == null) {
            return "";
        }
        String str = name.replace('\\', '/');
        if (str.indexOf(USER_DIR) > -1) {
            str = StringHelper.getString(str, USER_DIR, "${user.dir}");
        }
        if (MERLIN_HOME != null && str.indexOf(MERLIN_HOME) > -1) {
            str = StringHelper.getString(str, MERLIN_HOME, "${merlin.home}");
        } else if (MERLIN_REPO_LOCAL != null && str.indexOf(MERLIN_REPO_LOCAL) > -1) {
            str = StringHelper.getString(str, MERLIN_REPO_LOCAL, "${merlin.repository.local}");
        }
        return str;
    }

    public static String toString(File file) {
        if (file == null) {
            return "";
        }
        return StringHelper.toString(file.toString());
    }

    public static String toString(URL url) {
        if (url == null) {
            return "";
        }
        return StringHelper.toString(url.toString());
    }

    public static String toString(URL[] urls) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(StringHelper.toString(urls[i]));
        }
        return buffer.toString();
    }

    public static String toString(String[] names) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(StringHelper.toString(names[i]));
        }
        return buffer.toString();
    }

    private static String getString(String name, String pattern, String replacement) {
        int n = name.indexOf(pattern);
        if (n == -1) {
            return name;
        }
        if (name.startsWith(pattern)) {
            return replacement + name.substring(pattern.length());
        }
        String header = name.substring(0, n);
        String tail = name.substring(n + pattern.length());
        return header + replacement + tail;
    }

    private static String getUserDir() {
        return System.getProperty("user.dir").replace('\\', '/');
    }

    private static String getMerlinHome() {
        String home = System.getProperty("merlin.home");
        if (home == null) {
            return null;
        }
        return home.replace('\\', '/');
    }

    private static String getRepositoryLocal() {
        String local = System.getProperty("merlin.repository.local");
        if (local == null) {
            return null;
        }
        return local.replace('\\', '/');
    }
}

