/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.configuration;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.phoenix.tools.configuration.DTDInfo;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDResolver
implements EntityResolver {
    private final DTDInfo[] m_dtdInfos;
    private final ClassLoader m_classLoader;

    public DTDResolver(DTDInfo[] dtdInfos, ClassLoader classLoader) {
        this.m_dtdInfos = dtdInfos;
        this.m_classLoader = classLoader;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        int i = 0;
        while (i < this.m_dtdInfos.length) {
            DTDInfo info = this.m_dtdInfos[i];
            if (publicId != null && publicId.equals(info.getPublicId()) || systemId != null && systemId.equals(info.getSystemId())) {
                ClassLoader classLoader = this.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(info.getResource());
                return new InputSource(inputStream);
            }
            ++i;
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = this.m_classLoader;
        if (null == classLoader) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (null == classLoader) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }
}

