/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.tools.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;

public class Sar
extends Jar {
    private File m_config;
    private File m_assembly;
    private File m_environment;

    public Sar() {
        ((Zip)this).archiveType = "sar";
        ((Zip)this).emptyBehavior = "fail";
    }

    public void setSarfile(File file) {
        this.setDestFile(file);
    }

    public void setConfig(File config) {
        this.m_config = config;
        if (!this.m_config.exists()) {
            throw new BuildException("Config descriptor: " + this.m_config + " does not exist.");
        }
        if (!this.m_config.isFile()) {
            throw new BuildException("Config descriptor: " + this.m_config + " is not a file.");
        }
    }

    public void setAssembly(File assembly) {
        this.m_assembly = assembly;
        if (!this.m_assembly.exists()) {
            throw new BuildException("Assembly descriptor: " + this.m_assembly + " does not exist.");
        }
        if (!this.m_assembly.isFile()) {
            throw new BuildException("Assembly descriptor: " + this.m_assembly + " is not a file.");
        }
    }

    public void setServer(File server) {
        System.err.println("DEPRECATED: Server attribute of sar task is deprecated");
        this.setEnvironment(server);
    }

    public void setEnvironment(File environment) {
        this.m_environment = environment;
        if (!this.m_environment.exists()) {
            String message = "Environment descriptor: " + this.m_environment + " does not exist.";
            throw new BuildException(message);
        }
        if (!this.m_environment.isFile()) {
            String message = "Environment descriptor: " + this.m_environment + " is not a file.";
            throw new BuildException(message);
        }
    }

    public void addLib(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("SAR-INF/lib");
        super.addFileset((FileSet)zipFileSet);
    }

    public void addClasses(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("SAR-INF/classes");
        super.addFileset((FileSet)zipFileSet);
    }

    public void execute() throws BuildException {
        if (null == this.m_config) {
            throw new BuildException("config attribute is required", ((Task)this).location);
        }
        if (null == this.m_assembly) {
            throw new BuildException("assembly attribute is required", ((Task)this).location);
        }
        if (null == this.m_environment) {
            throw new BuildException("environment attribute is required", ((Task)this).location);
        }
        this.pushFile("SAR-INF/config.xml", this.m_config);
        this.pushFile("SAR-INF/assembly.xml", this.m_assembly);
        this.pushFile("SAR-INF/environment.xml", this.m_environment);
        super.execute();
    }

    private void pushFile(String path, File file) {
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setDir(new File(file.getParent()));
        zipFileSet.setIncludes(file.getName());
        zipFileSet.setFullpath(path);
        super.addFileset((FileSet)zipFileSet);
    }

    protected void cleanUp() {
        super.cleanUp();
        this.m_config = null;
        this.m_assembly = null;
        this.m_environment = null;
    }
}

