/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.CascadingIOException;

public abstract class AbstractURLConnection
extends URLConnection {
    AbstractURLConnection(URL url) throws IOException {
        super(url);
        String path = url.getPath();
        int i = path.lastIndexOf("/");
        if (i < 0) {
            String error = "Artifact specification does not contain a [group]/[name] seperator.";
            throw new MalformedURLException("Artifact specification does not contain a [group]/[name] seperator.");
        }
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.getContent();
    }

    public void connect() {
    }

    protected Object getContent(String type) throws IOException {
        try {
            String path = this.getURL().getPath();
            int i = path.lastIndexOf("/");
            String group = path.substring(0, i);
            String name = path.substring(i + 1);
            String version = this.getVersion(this.url);
            return Artifact.createArtifact(group, name, version, type);
        }
        catch (Throwable e) {
            String error = "Unexpected exception while resolving url [" + super.getURL() + "].";
            throw new CascadingIOException(error);
        }
    }

    protected String getVersion(URL url) {
        if (null != url.getRef()) {
            return url.getRef();
        }
        return this.getQueryField(url, "version", null);
    }

    protected String getQueryField(URL url, String field, String fallback) {
        String query = url.getQuery();
        if (null != query) {
            StringTokenizer tokenizer = new StringTokenizer(query, "&");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                if (!token.startsWith(field + "=")) continue;
                return token.substring(field.length() + 1);
            }
        }
        return fallback;
    }
}

