/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.directory.Attributes;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.cli.RepositoryVerifier;
import org.apache.avalon.repository.main.DefaultBuilder;
import org.apache.avalon.repository.main.DefaultInitialContextFactory;
import org.apache.avalon.repository.meta.ArtifactDescriptor;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.repository.util.RepositoryUtils;
import org.apache.avalon.util.env.Env;
import org.apache.avalon.util.exception.ExceptionHelper;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class Main {
    private static Resources REZ = ResourceManager.getPackageResources(class$org$apache$avalon$repository$cli$Main == null ? (class$org$apache$avalon$repository$cli$Main = Main.class$("org.apache.avalon.repository.cli.Main")) : class$org$apache$avalon$repository$cli$Main);
    private static final File USER_HOME = new File(System.getProperty("user.home"));
    private static final String AVALON_PROPERTIES = "avalon.properties";
    private static final String IMPLEMENTATION_KEY = "avalon.repository.implementation";
    private static Options CL_OPTIONS = Main.buildCommandLineOptions();
    private static Main MAIN = null;
    static /* synthetic */ Class class$org$apache$avalon$repository$cli$Main;

    private static Options buildCommandLineOptions() {
        Options options = new Options();
        Option help = new Option("help", REZ.getString("cli-help-description"));
        Option verify = new Option("verify", REZ.getString("cli-verify-description"));
        Option version = new Option("version", REZ.getString("cli-version-description"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("code");
        OptionBuilder.withDescription(REZ.getString("cli-language-description"));
        Option locale = OptionBuilder.create("lang");
        Option info = new Option("info", REZ.getString("cli-info-description"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("artifact");
        OptionBuilder.withDescription(REZ.getString("cli-implementation-description"));
        Option implementation = OptionBuilder.create("impl");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName(REZ.getString("directory"));
        OptionBuilder.withDescription(REZ.getString("cli-home-description"));
        Option home = OptionBuilder.create("home");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName(REZ.getString("directory"));
        OptionBuilder.withDescription(REZ.getString("cli-cache-description"));
        Option cache = OptionBuilder.create("cache");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName(REZ.getString("urls"));
        OptionBuilder.withDescription(REZ.getString("cli-hosts-description"));
        Option hosts = OptionBuilder.create("hosts");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName(REZ.getString("url"));
        OptionBuilder.withDescription(REZ.getString("cli-install-description"));
        Option install = OptionBuilder.create("install");
        options.addOption(help);
        options.addOption(locale);
        options.addOption(version);
        options.addOption(info);
        options.addOption(implementation);
        options.addOption(install);
        options.addOption(home);
        options.addOption(cache);
        options.addOption(hosts);
        options.addOption(verify);
        return options;
    }

    public static void main(String[] args) {
        try {
            BasicParser parser = new BasicParser();
            CommandLine line = parser.parse(CL_OPTIONS, args);
            File dir = Main.getWorkingDirectory(line);
            File cache = Main.getCacheDirectory(line);
            Artifact artifact = Main.getDefaultImplementation(dir, line);
            if (line.hasOption("version")) {
                Main.printVersionInfo(cache, artifact);
                return;
            }
            if (line.hasOption("help")) {
                Main.doHelp(line);
                return;
            }
            ClassLoader parent = (class$org$apache$avalon$repository$cli$Main == null ? (class$org$apache$avalon$repository$cli$Main = Main.class$("org.apache.avalon.repository.cli.Main")) : class$org$apache$avalon$repository$cli$Main).getClassLoader();
            String[] hosts = Main.getHostsPath(line);
            DefaultInitialContextFactory factory = new DefaultInitialContextFactory("avalon", dir);
            factory.setCacheDirectory(cache);
            factory.setHosts(hosts);
            InitialContext context = factory.createInitialContext();
            MAIN = new Main(context, line);
        }
        catch (Throwable e) {
            String msg = ExceptionHelper.packException(e, true);
            System.err.println(msg);
            System.exit(-1);
        }
    }

    private static void doHelp(CommandLine line) {
        if (line.hasOption("lang")) {
            ResourceManager.clearResourceCache();
            String language = line.getOptionValue("lang");
            Locale locale = new Locale(language, "");
            Locale.setDefault(locale);
            REZ = ResourceManager.getPackageResources(class$org$apache$avalon$repository$cli$Main == null ? (class$org$apache$avalon$repository$cli$Main = Main.class$("org.apache.avalon.repository.cli.Main")) : class$org$apache$avalon$repository$cli$Main);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("repository [artifact]", " ", Main.buildCommandLineOptions(), "", true);
    }

    public Main(InitialContext context, CommandLine line) throws Exception {
        if (line.hasOption("info")) {
            StringBuffer buffer = new StringBuffer("\n-----------------------------------------------------------");
            buffer.append("\nAvalon Repository");
            buffer.append("\n-----------------------------------------------------------");
            this.prepareInfoListing(buffer, context);
            buffer.append("\n-----------------------------------------------------------");
            System.out.println(buffer.toString());
        }
        if (line.hasOption("install")) {
            this.doInstall(context, line);
        } else if (line.hasOption("verify")) {
            this.doVerify(context);
        } else {
            Main.doHelp(line);
        }
    }

    private void prepareInfoListing(StringBuffer buffer, InitialContext context) {
        buffer.append("\n${avalon.repository.cache} = ");
        buffer.append(context.getInitialCacheDirectory());
        buffer.append("\n${avalon.dir} = ");
        buffer.append(context.getInitialWorkingDirectory());
        String[] hosts = context.getInitialHosts();
        buffer.append("\n${avalon.repository.hosts} = (");
        buffer.append(hosts.length);
        buffer.append(")");
        for (int i = 0; i < hosts.length; ++i) {
            buffer.append("\n  " + hosts[i]);
        }
    }

    private void doInstall(InitialContext context, CommandLine line) throws Exception {
        URL url = this.getInstallTarget(line);
        try {
            context.install(url);
        }
        catch (Throwable e) {
            String error = "Install failure: " + url;
            throw new RepositoryException(error, e);
        }
    }

    private void doVerify(InitialContext context) throws Exception {
        RepositoryVerifier verifier = new RepositoryVerifier(context);
        verifier.verify();
    }

    private static File getWorkingDirectory(CommandLine line) throws Exception {
        if (line.hasOption("home")) {
            String dir = line.getOptionValue("home");
            return new File(dir).getCanonicalFile();
        }
        return Main.getBaseDirectory();
    }

    private static String[] getHostsPath(CommandLine line) {
        if (line.hasOption("hosts")) {
            String hosts = line.getOptionValue("hosts");
            return Main.expandHosts(hosts);
        }
        return null;
    }

    private static String[] expandHosts(String arg) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(arg, ",");
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            list.add(next);
        }
        return list.toArray(new String[0]);
    }

    private URL getInstallTarget(CommandLine line) throws IOException {
        String spec = line.getOptionValue("install");
        return new URL(spec);
    }

    private static Artifact getDefaultImplementation(File base, CommandLine line) throws Exception {
        if (line.hasOption("impl")) {
            String spec = line.getOptionValue("impl");
            return Artifact.createArtifact(spec);
        }
        return DefaultBuilder.createImplementationArtifact((class$org$apache$avalon$repository$cli$Main == null ? (class$org$apache$avalon$repository$cli$Main = Main.class$("org.apache.avalon.repository.cli.Main")) : class$org$apache$avalon$repository$cli$Main).getClassLoader(), Main.getAvalonHome(), Main.getBaseDirectory(), AVALON_PROPERTIES, IMPLEMENTATION_KEY);
    }

    private static void printVersionInfo(File cache, Artifact artifact) {
        try {
            Attributes attr = RepositoryUtils.getAttributes(cache, artifact);
            ArtifactDescriptor desc = new ArtifactDescriptor(attr);
            System.out.println("\n  Implementation: " + artifact.getGroup() + ":" + artifact.getName() + ";" + artifact.getVersion() + " (" + desc.getBuild() + ")");
        }
        catch (Throwable e) {
            System.out.println("\nImplementation: " + artifact.getGroup() + ":" + artifact.getName() + ";" + artifact.getVersion());
        }
    }

    private static File getCacheDirectory(CommandLine line) {
        if (line.hasOption("cache")) {
            String system = line.getOptionValue("cache");
            return new File(system);
        }
        return new File(Main.getAvalonHome(), "repository");
    }

    private static File getAvalonHome() {
        return new File(Main.getAvalonHomePath());
    }

    private static String getAvalonHomePath() {
        return Main.getHomePath("AVALON_HOME", ".avalon");
    }

    private static String getHomePath(String var, String dir) {
        try {
            String avalon = System.getProperty("avalon.home", Env.getEnvVariable(var));
            if (null != avalon) {
                return avalon;
            }
            return System.getProperty("user.home") + File.separator + dir;
        }
        catch (Throwable e) {
            String error = "Internal error while attempting to access AVALON_HOME environment.";
            String message = ExceptionHelper.packException("Internal error while attempting to access AVALON_HOME environment.", e, true);
            throw new RuntimeException(message);
        }
    }

    private static File getBaseDirectory() {
        String path = System.getProperty("avalon.dir");
        if (null != path) {
            return new File(path);
        }
        String base = System.getProperty("basedir");
        if (null != base) {
            return new File(base);
        }
        return new File(System.getProperty("user.dir"));
    }

    private static Properties getLocalProperties(File dir, String filename) {
        Properties properties = new Properties();
        if (null == dir) {
            return properties;
        }
        File file = new File(dir, filename);
        if (!file.exists()) {
            return properties;
        }
        try {
            properties.load(new FileInputStream(file));
            return properties;
        }
        catch (Throwable e) {
            String error = "Unexpected exception while attempting to read properties from: " + file + ". Cause: " + e.toString();
            throw new IllegalStateException(error);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

