/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.cli;

import java.io.File;
import java.io.FileFilter;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class RepositoryVerifier {
    private static Resources REZ = ResourceManager.getPackageResources(class$org$apache$avalon$repository$cli$RepositoryVerifier == null ? (class$org$apache$avalon$repository$cli$RepositoryVerifier = RepositoryVerifier.class$("org.apache.avalon.repository.cli.RepositoryVerifier")) : class$org$apache$avalon$repository$cli$RepositoryVerifier);
    private static final String PADDING = "                                                                ";
    private final InitialContext m_context;
    private final String m_root;
    static /* synthetic */ Class class$org$apache$avalon$repository$cli$RepositoryVerifier;

    public RepositoryVerifier(InitialContext context) throws Exception {
        this.m_context = context;
        this.m_root = this.m_context.getInitialCacheDirectory().toString();
    }

    void verify() {
        StringBuffer buffer = new StringBuffer("\n-----------------------------------------------------------");
        buffer.append("\nAvalon Repository");
        buffer.append("\n-----------------------------------------------------------");
        this.prepareInfoListing(buffer);
        buffer.append("\n-----------------------------------------------------------");
        this.prepareContentListing(buffer);
        buffer.append("\n-----------------------------------------------------------");
        System.out.println(buffer.toString());
    }

    private void prepareInfoListing(StringBuffer buffer) {
        buffer.append("\n${avalon.repository.cache} = ");
        buffer.append(this.m_context.getInitialCacheDirectory());
        buffer.append("\n${avalon.dir} = ");
        buffer.append(this.m_context.getInitialWorkingDirectory());
        String[] hosts = this.m_context.getInitialHosts();
        buffer.append("\n${avalon.repository.hosts} = (");
        buffer.append(hosts.length);
        buffer.append(")");
        for (int i = 0; i < hosts.length; ++i) {
            buffer.append("\n  " + hosts[i]);
        }
    }

    private void prepareContentListing(StringBuffer buffer) {
        File cache = this.m_context.getInitialCacheDirectory();
        File[] groups = this.getGroups(cache);
        int n = this.getGroupsWidth(groups);
        for (int i = 0; i < groups.length; ++i) {
            this.prepareGroupListing(buffer, groups[i], n);
        }
    }

    private int getGroupsWidth(File[] groups) {
        int n = 0;
        for (int i = 0; i < groups.length; ++i) {
            File group = groups[i];
            int j = group.toString().length();
            if (j <= n) continue;
            n = j;
        }
        return n;
    }

    private void prepareGroupListing(StringBuffer buffer, File file, int n) {
        int rootLength = this.m_root.length() + 1;
        String path = file.toString();
        String group = path.substring(rootLength);
        int offset = n - rootLength + 3;
        int padding = offset - group.length();
        String pad = PADDING.substring(0, padding);
        buffer.append("\n");
        buffer.append("  " + group + pad);
        this.prepareTypeSummary(buffer, file);
    }

    private void prepareTypeSummary(StringBuffer buffer, File file) {
        File[] types = file.listFiles(new TypesFilter());
        for (int i = 0; i < types.length; ++i) {
            File type = types[i];
            String key = type.getName();
            File[] versions = type.listFiles(new VersionedArtifactFilter(key));
            if (i > 0) {
                buffer.append(", ");
            } else {
                buffer.append(" ");
            }
            buffer.append(type.getName() + ":" + versions.length);
        }
    }

    private File[] getGroups(File root) {
        return root.listFiles(new DirectoryFilter());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ArtifactFilter
    implements FileFilter {
        private String m_type;

        public ArtifactFilter(String type) {
            int n = type.length();
            this.m_type = type.substring(0, n - 1);
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            return file.getName().endsWith(this.m_type);
        }
    }

    private class VersionedArtifactFilter
    extends ArtifactFilter {
        public VersionedArtifactFilter(String type) {
            super(type);
        }

        public boolean accept(File file) {
            return super.accept(file);
        }
    }

    private class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private class TypesFilter
    implements FileFilter {
        private TypesFilter() {
        }

        public boolean accept(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            String type = file.getName();
            File[] artifacts = file.listFiles(new ArtifactFilter(type));
            return artifacts.length > 0;
        }
    }
}

