/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.naming.directory.Attributes;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.RepositoryRuntimeException;
import org.apache.avalon.repository.main.AbstractBuilder;
import org.apache.avalon.repository.meta.FactoryDescriptor;
import org.apache.avalon.repository.provider.Builder;
import org.apache.avalon.repository.provider.Factory;
import org.apache.avalon.repository.provider.InitialContext;

public class DefaultBuilder
extends AbstractBuilder
implements Builder {
    private static final File USER = new File(System.getProperty("user.home"));
    private final Repository m_repository;
    private final ClassLoader m_classloader;
    private final InitialContext m_context;
    private final Class m_class;
    private final Factory m_delegate;
    static /* synthetic */ Class class$org$apache$avalon$repository$provider$Factory;
    static /* synthetic */ Class class$org$apache$avalon$repository$main$DefaultBuilder;

    public static Artifact createImplementationArtifact(ClassLoader classloader, File base, String resource, String key) throws Exception {
        return DefaultBuilder.createImplementationArtifact(classloader, null, base, resource, key);
    }

    public static Artifact createImplementationArtifact(ClassLoader classloader, File system, File base, String resource, String key) throws Exception {
        String spec = DefaultBuilder.getLocalProperties(base, resource).getProperty(key);
        if (null == spec) {
            spec = DefaultBuilder.getLocalProperties(USER, resource).getProperty(key);
        }
        if (null == spec) {
            spec = DefaultBuilder.getLocalProperties(system, resource).getProperty(key);
        }
        if (null == spec) {
            Properties properties = new Properties();
            InputStream input = classloader.getResourceAsStream(resource);
            if (input == null) {
                String error = "Missing resource: [" + resource + "]";
                throw new IllegalStateException(error);
            }
            properties.load(input);
            spec = properties.getProperty(key);
            if (spec == null) {
                String error = "Missing property: [" + key + "] in resource: [" + resource + "]";
                throw new IllegalStateException(error);
            }
        }
        return Artifact.createArtifact(spec);
    }

    private static Properties getLocalProperties(File dir, String filename) throws IOException {
        Properties properties = new Properties();
        if (null == dir) {
            return properties;
        }
        File file = new File(dir, filename);
        if (!file.exists()) {
            return properties;
        }
        properties.load(new FileInputStream(file));
        return properties;
    }

    public DefaultBuilder(InitialContext context, Artifact artifact) throws Exception {
        this(context, null, artifact);
    }

    public DefaultBuilder(InitialContext context, ClassLoader classloader, Artifact artifact) throws Exception {
        if (null == context) {
            throw new NullPointerException("context");
        }
        if (null == artifact) {
            throw new NullPointerException("artifact");
        }
        this.m_context = context;
        ClassLoader parent = this.getClassLoader(classloader);
        this.m_repository = this.m_context.getRepository();
        Attributes attributes = this.m_repository.getAttributes(artifact);
        FactoryDescriptor descriptor = new FactoryDescriptor(attributes);
        String classname = descriptor.getFactory();
        if (null == classname) {
            String error = "Required property 'avalon.artifact.factory' not present in artifact: [" + artifact + "] under the active repository: [" + this.m_repository + "].";
            throw new IllegalArgumentException(error);
        }
        this.m_classloader = this.m_repository.getClassLoader(parent, artifact);
        this.m_class = this.loadFactoryClass(this.m_classloader, classname);
        if ((class$org$apache$avalon$repository$provider$Factory == null ? (class$org$apache$avalon$repository$provider$Factory = DefaultBuilder.class$("org.apache.avalon.repository.provider.Factory")) : class$org$apache$avalon$repository$provider$Factory).isAssignableFrom(this.m_class)) {
            try {
                this.m_delegate = this.createDelegate(this.m_classloader, this.m_class, this.m_context);
            }
            catch (Throwable e) {
                String error = "Unable to establish a factory for the supplied artifact:";
                StringBuffer buffer = new StringBuffer("Unable to establish a factory for the supplied artifact:");
                buffer.append("\n artifact: " + artifact);
                buffer.append("\n build: " + descriptor.getBuild());
                buffer.append("\n factory: " + descriptor.getFactory());
                buffer.append("\n source: " + this.m_class.getProtectionDomain().getCodeSource().getLocation());
                buffer.append("\n repository: " + this.m_repository);
                throw new RepositoryException(buffer.toString(), e);
            }
        } else {
            this.m_delegate = null;
        }
    }

    public Class getFactoryClass() {
        return this.m_class;
    }

    public Factory getFactory() {
        if (null != this.m_delegate) {
            return this.m_delegate;
        }
        String error = "Supplied class [" + this.m_class.getName() + "] does not implement the Factory interface.";
        throw new RepositoryRuntimeException(error);
    }

    public ClassLoader getClassLoader() {
        return this.m_classloader;
    }

    private ClassLoader getClassLoader(ClassLoader classloader) {
        if (null != classloader) {
            return classloader;
        }
        return (class$org$apache$avalon$repository$main$DefaultBuilder == null ? (class$org$apache$avalon$repository$main$DefaultBuilder = DefaultBuilder.class$("org.apache.avalon.repository.main.DefaultBuilder")) : class$org$apache$avalon$repository$main$DefaultBuilder).getClassLoader();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

