/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.criteria;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.apache.avalon.util.criteria.CriteriaException;

public class Parameter
implements Serializable {
    private final String m_key;
    private final Class m_type;
    private final boolean m_required;
    private final Object m_default;

    public static String[] getKeys(Parameter[] params) {
        String[] keys = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            keys[i] = params[i].getKey();
        }
        return keys;
    }

    public Parameter(String key, Class type) {
        this.m_key = key;
        this.m_type = type;
        this.m_required = true;
        this.m_default = null;
    }

    public Parameter(String key, Class type, Object value) {
        this.m_key = key;
        this.m_type = type;
        this.m_required = false;
        this.m_default = value;
    }

    public String getKey() {
        return this.m_key;
    }

    public Class getParameterClass() {
        return this.m_type;
    }

    public boolean isRequired() {
        return this.m_required;
    }

    public boolean isOptional() {
        return !this.isRequired();
    }

    public Object getDefault() {
        return this.m_default;
    }

    public Object resolve(Object value) throws CriteriaException {
        return this.resolve(this.m_type, value);
    }

    protected Object resolve(Class type, Object value) throws CriteriaException {
        if (value == null) {
            return null;
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (type.isInstance(value)) {
            return value;
        }
        Constructor constructor = null;
        try {
            constructor = type.getConstructor(value.getClass());
        }
        catch (NoSuchMethodException nsme) {
            String error = "Value of class: [" + value.getClass().getName() + "] supplied for key [" + this.getKey() + "] is not an instance of type: [" + type.getName() + "].";
            throw new CriteriaException(error);
        }
        try {
            return constructor.newInstance(value);
        }
        catch (Throwable e) {
            String error = "Value of class: [" + value.getClass().getName() + "] supplied for key [" + this.getKey() + "] is not an instance of or was not resolvable to the type: [" + type.getName() + "].";
            throw new CriteriaException(error, e);
        }
    }
}

