/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.env;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.util.env.EnvAccessException;

public class Env
extends Properties {
    public static final String OSNAME = System.getProperty("os.name");
    public static final String USERNAME = System.getProperty("user.name");
    private static String s_shell = null;
    private static Env s_lastEnv = null;

    public Env() throws EnvAccessException {
        Properties l_props = Env.getEnvVariables();
        Enumeration<?> l_list = l_props.propertyNames();
        while (l_list.hasMoreElements()) {
            String l_key = (String)l_list.nextElement();
            this.setProperty(l_key, l_props.getProperty(l_key));
        }
        s_lastEnv = this;
    }

    Env getLastEnv() throws EnvAccessException {
        if (s_lastEnv == null) {
            s_lastEnv = new Env();
        }
        return (Env)((Hashtable)s_lastEnv).clone();
    }

    public static String getEnvVariable(String a_name) throws EnvAccessException {
        String l_osName = System.getProperty("os.name");
        if (Env.isUnix()) {
            Properties l_props = Env.getUnixShellVariables();
            return l_props.getProperty(a_name);
        }
        if (-1 != l_osName.indexOf("Windows")) {
            if (null == s_shell) {
                s_shell = -1 != l_osName.indexOf("98") || -1 != l_osName.indexOf("95") ? "command.exe" : "cmd.exe";
            }
            return Env.getWindowsShellVariable(a_name);
        }
        throw new EnvAccessException(a_name, "Unrecognized operating system: " + l_osName);
    }

    public static boolean isUnix() {
        return -1 != OSNAME.indexOf("Linux") || -1 != OSNAME.indexOf("SunOS") || -1 != OSNAME.indexOf("Solaris") || -1 != OSNAME.indexOf("MPE/iX") || -1 != OSNAME.indexOf("AIX") || -1 != OSNAME.indexOf("FreeBSD") || -1 != OSNAME.indexOf("Irix") || -1 != OSNAME.indexOf("Digital Unix") || -1 != OSNAME.indexOf("HP-UX") || -1 != OSNAME.indexOf("Mac OS X");
    }

    public static boolean isWindows() {
        return -1 != OSNAME.indexOf("Windows");
    }

    public static boolean isNetWare() {
        return -1 != OSNAME.indexOf("netware");
    }

    public static boolean isOpenVMS() {
        return -1 != OSNAME.indexOf("openvms");
    }

    public static Properties getEnvVariables() throws EnvAccessException {
        if (Env.isUnix()) {
            return Env.getUnixShellVariables();
        }
        if (Env.isWindows()) {
            return Env.getWindowsShellVariables();
        }
        throw new EnvAccessException(new UnsupportedOperationException("Environment operations not supported on unrecognized operatings system"));
    }

    public static String getUserShell() throws EnvAccessException {
        if (-1 != OSNAME.indexOf("Mac OS X")) {
            return Env.getMacUserShell();
        }
        if (Env.isWindows()) {
            return Env.getWindowsUserShell();
        }
        throw new EnvAccessException(new UnsupportedOperationException("Environment operations not supported on unrecognized operatings system"));
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getMacUserShell() throws EnvAccessException {
        block16: {
            block15: {
                l_proc = null;
                l_in = null;
                if (null != Env.s_shell) {
                    return Env.s_shell;
                }
                try {
                    try {
                        l_entry = null;
                        l_args = new String[]{"nidump", "passwd", "/"};
                        l_proc = Runtime.getRuntime().exec(l_args);
                        l_in = new BufferedReader(new InputStreamReader(l_proc.getInputStream()));
                        while (null != (l_entry = l_in.readLine())) {
                            if (!l_entry.startsWith(Env.USERNAME)) continue;
                            l_index = l_entry.lastIndexOf(58);
                            if (l_index == -1) {
                                throw new EnvAccessException("passwd database contains malformed user entry for " + Env.USERNAME);
                            }
                            var5_6 = Env.s_shell = l_entry.substring(l_index + 1);
                            var7_7 = null;
                            if (l_proc != null) {
                                l_proc.destroy();
                            }
                            break block15;
                        }
                        l_proc.waitFor();
                        l_in.close();
                        break block16;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        throw new EnvAccessException(t);
                    }
                }
                catch (Throwable var6_13) {
                    var7_9 = null;
                    if (l_proc != null) {
                        l_proc.destroy();
                    }
                    try {
                        if (null == l_in) throw var6_13;
                        l_in.close();
                        throw var6_13;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var6_13;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 199->211)] { 
lbl43:
            // 1 sources

            if (null == l_in) return var5_6;
            l_in.close();
            return var5_6;
lbl46:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var5_6;
        }
        var7_8 = null;
        if (l_proc != null) {
            l_proc.destroy();
        }
        try {}
        catch (IOException e) {}
        if (null == l_in) throw new EnvAccessException("User " + Env.USERNAME + " does not seem to exist in the passwd database");
        l_in.close();
        throw new EnvAccessException("User " + Env.USERNAME + " does not seem to exist in the passwd database");
        throw new EnvAccessException("User " + Env.USERNAME + " does not seem to exist in the passwd database");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getUnixShellVariables() throws EnvAccessException {
        Process l_proc = null;
        Properties l_props = new Properties();
        BufferedReader l_in = null;
        try {
            try {
                String[] l_args = new String[]{Env.getUnixEnv()};
                l_proc = Runtime.getRuntime().exec(l_args);
                l_in = new BufferedReader(new InputStreamReader(l_proc.getInputStream()));
                String l_line = null;
                while (null != (l_line = l_in.readLine())) {
                    int l_idx = l_line.indexOf(61);
                    if (-1 == l_idx) {
                        if (l_line.length() == 0) continue;
                        System.err.println("Skipping line - could not find '=' in line: '" + l_line + "'");
                        continue;
                    }
                    String l_name = l_line.substring(0, l_idx);
                    String l_value = l_line.substring(l_idx + 1, l_line.length());
                    l_props.setProperty(l_name, l_value);
                }
                l_proc.waitFor();
                l_in.close();
            }
            catch (Throwable t) {
                throw new EnvAccessException("NA", t);
            }
            Object var9_9 = null;
            l_proc.destroy();
            {
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            l_proc.destroy();
            try {
                if (null == l_in) throw throwable;
                l_in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (null != l_in) {
            l_in.close();
        }
        if (0 == l_proc.exitValue()) return l_props;
        throw new EnvAccessException("Environment process failed  with non-zero exit code of " + l_proc.exitValue());
    }

    private static String getUnixEnv() throws EnvAccessException {
        File l_env = new File("/bin/env");
        if (l_env.exists() && l_env.canRead() && l_env.isFile()) {
            return l_env.getAbsolutePath();
        }
        l_env = new File("/usr/bin/env");
        if (l_env.exists() && l_env.canRead() && l_env.isFile()) {
            return l_env.getAbsolutePath();
        }
        throw new EnvAccessException("Could not find the UNIX env executable");
    }

    private static String getWindowsUserShell() {
        if (null != s_shell) {
            return s_shell;
        }
        if (-1 != OSNAME.indexOf("98") || -1 != OSNAME.indexOf("95")) {
            s_shell = "command.exe";
            return s_shell;
        }
        s_shell = "cmd.exe";
        return s_shell;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getWindowsShellVariables() throws EnvAccessException {
        String l_line = null;
        Process l_proc = null;
        BufferedReader l_in = null;
        Properties l_props = new Properties();
        StringBuffer l_cmd = new StringBuffer();
        if (-1 != OSNAME.indexOf("98") || -1 != OSNAME.indexOf("95")) {
            l_cmd.append("command.exe /C SET");
        } else {
            l_cmd.append("cmd.exe /C SET");
        }
        try {
            try {
                l_proc = Runtime.getRuntime().exec(l_cmd.toString());
                l_in = new BufferedReader(new InputStreamReader(l_proc.getInputStream()));
                while (null != (l_line = l_in.readLine())) {
                    int l_idx = l_line.indexOf(61);
                    if (-1 == l_idx) {
                        System.err.println("Skipping line - could not find '=' in line: '" + l_line + "'");
                        continue;
                    }
                    String l_name = l_line.substring(0, l_idx);
                    String l_value = l_line.substring(l_idx + 1, l_line.length());
                    l_props.setProperty(l_name, l_value);
                }
                l_proc.waitFor();
                l_in.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new EnvAccessException(t);
            }
            Object var9_9 = null;
            l_proc.destroy();
            {
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            l_proc.destroy();
            try {
                if (null == l_in) throw throwable;
                l_in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (null != l_in) {
            l_in.close();
        }
        if (0 == l_proc.exitValue()) return l_props;
        throw new EnvAccessException("Environment process failed with non-zero exit code of " + l_proc.exitValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getWindowsShellVariable(String a_name) throws EnvAccessException {
        String l_value = null;
        Process l_proc = null;
        BufferedReader l_in = null;
        StringBuffer l_cmd = new StringBuffer(Env.getWindowsUserShell());
        l_cmd.append(" /C echo %");
        l_cmd.append(a_name);
        l_cmd.append('%');
        try {
            try {
                l_proc = Runtime.getRuntime().exec(l_cmd.toString());
                l_in = new BufferedReader(new InputStreamReader(l_proc.getInputStream()));
                l_value = l_in.readLine();
                l_proc.waitFor();
                l_in.close();
            }
            catch (Throwable t) {
                throw new EnvAccessException(a_name, t);
            }
            Object var7_5 = null;
            l_proc.destroy();
            {
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            l_proc.destroy();
            try {
                if (null == l_in) throw throwable;
                l_in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (null != l_in) {
            l_in.close();
        }
        if (0 != l_proc.exitValue()) throw new EnvAccessException(a_name, "Environment process failed with non-zero exit code of " + l_proc.exitValue());
        if (!l_value.startsWith("%")) return l_value;
        if (!l_value.endsWith("%")) return l_value;
        return null;
    }
}

