/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;

public class ArtifactDescriptor
implements Serializable {
    private String m_name = null;
    private String m_type = null;
    private String m_group = null;
    private String m_version = null;
    private transient String m_spec = null;
    private transient boolean m_isDirty = true;

    public ArtifactDescriptor(String a_spec) throws ParseException {
        this.m_spec = a_spec;
        this.m_type = "jar";
        int l_colon = a_spec.indexOf(58);
        if (-1 == l_colon) {
            throw new ParseException("Malformed Merlin artifact specification: no colon in specification.", 0);
        }
        int l_semiColon = a_spec.indexOf(59);
        if (-1 == l_semiColon) {
            throw new ParseException("Malformed Merlin artifact specification: no semi-colon in specification.", 0);
        }
        if (l_colon >= l_semiColon) {
            throw new ParseException("Malformed Merlin artifact specification: colon index greater than semicolon index", 0);
        }
        this.m_group = a_spec.substring(0, l_colon);
        this.m_name = a_spec.substring(l_colon, l_semiColon);
        this.m_version = a_spec.substring(l_semiColon);
    }

    public ArtifactDescriptor(String a_group, String a_name, String a_type, String a_version) {
        if (null == a_group) {
            throw new NullPointerException("a_group");
        }
        if (null == a_name) {
            throw new NullPointerException("a_name");
        }
        if (null == a_type) {
            throw new NullPointerException("a_type");
        }
        if (null == a_version) {
            throw new NullPointerException("a_version");
        }
        this.m_name = a_name;
        this.m_type = a_type;
        this.m_group = a_group;
        this.m_version = a_version;
    }

    public String getGroup() {
        return this.m_group;
    }

    public void setGroup(String a_group) {
        this.m_isDirty = true;
        this.m_group = a_group;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String a_name) {
        this.m_isDirty = true;
        this.m_name = a_name;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String a_type) {
        this.m_isDirty = true;
        this.m_type = a_type;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String a_version) {
        this.m_isDirty = true;
        this.m_version = a_version;
    }

    public String getSpecification() {
        if (null == this.m_spec || this.m_isDirty) {
            this.m_spec = ArtifactDescriptor.createSpecification(this.m_group, this.m_name, this.m_version);
            this.m_isDirty = false;
        }
        return this.m_spec;
    }

    public String toString() {
        return this.getSpecification();
    }

    public String getRelativePath(char a_separator) {
        StringBuffer l_buf = new StringBuffer();
        l_buf.append(this.m_group);
        l_buf.append(a_separator);
        l_buf.append("jars");
        l_buf.append(a_separator);
        l_buf.append(this.m_name);
        l_buf.append('-');
        l_buf.append(this.m_version);
        l_buf.append(".jar");
        return l_buf.toString();
    }

    public URL getUrl(URL a_repository) throws MalformedURLException {
        StringBuffer l_buf = new StringBuffer(a_repository.toExternalForm());
        String l_relative = this.getRelativePath('/');
        if ('/' == l_buf.charAt(l_buf.length() - 1)) {
            l_buf.append(this.getRelativePath('/'));
        } else {
            l_buf.append('/');
            l_buf.append(this.getRelativePath('/'));
        }
        return new URL(l_buf.toString());
    }

    public static String createSpecification(String a_group, String a_name, String a_version) {
        StringBuffer l_buf = new StringBuffer();
        l_buf.append(a_group);
        l_buf.append(':');
        l_buf.append(a_name);
        l_buf.append(';');
        l_buf.append(a_version);
        return l_buf.toString();
    }
}

