/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.repository.Repository;
import org.apache.avalon.repository.RepositoryConfig;
import org.apache.avalon.repository.RepositoryException;
import org.apache.avalon.repository.RepositoryFactory;

public class RepositoryLoader
implements RepositoryFactory {
    public static final String URLS_BASE = "url";
    public static final String FACTORY_KEY = "factory";
    public static final String PROPS = "repository.properties";
    private RepositoryFactory m_delegate = null;
    static /* synthetic */ Class class$org$apache$avalon$repository$RepositoryLoader;

    public RepositoryLoader() throws RepositoryException {
        String l_userHome = System.getProperty("user.home");
        File l_tmpDir = new File(l_userHome, ".bootstrap");
        if (!l_tmpDir.exists()) {
            l_tmpDir.mkdirs();
        }
        Properties l_props = new Properties();
        try {
            Class l_clazz = class$org$apache$avalon$repository$RepositoryLoader == null ? (class$org$apache$avalon$repository$RepositoryLoader = RepositoryLoader.class$("org.apache.avalon.repository.RepositoryLoader")) : class$org$apache$avalon$repository$RepositoryLoader;
            l_props.load(l_clazz.getResourceAsStream(PROPS));
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to read repository.properties", e);
        }
        ArrayList<URL> l_urlsList = new ArrayList<URL>();
        Enumeration<?> l_list = l_props.propertyNames();
        while (l_list.hasMoreElements()) {
            String l_key = (String)l_list.nextElement();
            if (!l_key.startsWith(URLS_BASE)) continue;
            String l_url = l_props.getProperty(l_key);
            int l_fileIdx = l_url.lastIndexOf(47);
            String l_fileName = l_url.substring(l_fileIdx + 1);
            File l_localFile = new File(l_tmpDir, l_fileName);
            boolean l_isSuccess = false;
            try {
                l_isSuccess = RepositoryLoader.getTempFile(l_url, l_localFile, true);
            }
            catch (Exception e) {
                throw new RepositoryException("Failed to download bootstrap jar: " + l_url, e);
            }
            try {
                l_urlsList.add(new URL(l_url));
            }
            catch (MalformedURLException e) {
                throw new RepositoryException(l_url + " not a valid URL", e);
            }
        }
        if (!((Hashtable)l_props).containsKey(FACTORY_KEY)) {
            throw new RepositoryException("Factory property factory must be defined for a factory implementation.");
        }
        String l_factory = l_props.getProperty(FACTORY_KEY);
        URLClassLoader l_loader = new URLClassLoader(l_urlsList.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
        try {
            Class<?> l_clazz = l_loader.loadClass(l_factory);
            this.m_delegate = (RepositoryFactory)l_clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException("Could not default constructor on: " + l_factory, e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException("Could not instantiate the factory class: " + l_factory, e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException("Could not find the factory class: " + l_factory, e);
        }
    }

    public Repository create(RepositoryConfig a_config) throws RepositoryException {
        return this.m_delegate.create(a_config);
    }

    public RepositoryConfig getDefaultConfig() throws RepositoryException {
        return this.m_delegate.getDefaultConfig();
    }

    public static boolean getTempFile(String a_url, File a_destFile, boolean a_useTimestamp) throws Exception {
        long l_remoteTimestamp;
        int length;
        URL l_source = null;
        String l_username = null;
        String l_password = null;
        int l_atIdx = a_url.indexOf("@");
        if (l_atIdx > 0) {
            String s = a_url.substring(7, l_atIdx);
            int l_colonIdx = s.indexOf(":");
            l_username = s.substring(0, l_colonIdx);
            l_password = s.substring(l_colonIdx + 1);
            l_source = new URL("http://" + a_url.substring(l_atIdx + 1));
        } else {
            l_source = new URL(a_url);
        }
        long l_timestamp = 0L;
        boolean l_hasTimestamp = false;
        if (a_useTimestamp && a_destFile.exists()) {
            l_timestamp = a_destFile.lastModified();
            l_hasTimestamp = true;
        }
        URLConnection l_connection = l_source.openConnection();
        if (a_useTimestamp && l_hasTimestamp) {
            l_connection.setIfModifiedSince(l_timestamp);
        }
        l_connection.connect();
        if (l_connection instanceof HttpURLConnection) {
            HttpURLConnection l_httpConnection = (HttpURLConnection)l_connection;
            if (l_httpConnection.getResponseCode() == 304) {
                return false;
            }
            if (l_httpConnection.getResponseCode() == 401) {
                throw new Exception("Not authorized.");
            }
        }
        InputStream l_in = null;
        for (int ii = 0; ii < 3; ++ii) {
            try {
                l_in = l_connection.getInputStream();
                break;
            }
            catch (IOException ex) {
                continue;
            }
        }
        if (l_in == null) {
            String error = "Connection returned a null input stream: " + a_url;
            throw new IOException(error);
        }
        File parent = a_destFile.getParentFile();
        parent.mkdirs();
        FileOutputStream l_out = new FileOutputStream(a_destFile);
        byte[] buffer = new byte[102400];
        System.out.print("Source: " + l_source + "\n");
        while ((length = l_in.read(buffer)) >= 0) {
            l_out.write(buffer, 0, length);
            System.out.print(".");
        }
        System.out.println("");
        l_out.close();
        l_in.close();
        if (a_useTimestamp && (l_remoteTimestamp = l_connection.getLastModified()) != 0L) {
            long l_modifiedTime = l_remoteTimestamp < 0L ? System.currentTimeMillis() : l_remoteTimestamp;
            a_destFile.setLastModified(l_modifiedTime);
            return true;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

