/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.repository.meta;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.avalon.repository.Artifact;
import org.apache.avalon.repository.RepositoryRuntimeException;
import org.apache.avalon.repository.meta.ArtifactDescriptor;
import org.apache.avalon.repository.meta.MetaException;

public class FactoryDescriptor
extends ArtifactDescriptor {
    public static final String API_KEY = "avalon.artifact.dependency.api";
    public static final String SPI_KEY = "avalon.artifact.dependency.spi";
    public static final String IMP_KEY = "avalon.artifact.dependency";
    public static final String FACTORY_KEY = "avalon.artifact.factory";
    public static final String EXPORT_KEY = "avalon.artifact.export";
    private final Artifact[] c_api;
    private final Artifact[] c_spi;
    private final Artifact[] c_imp;
    private final String m_factory;
    private final String m_interface;

    public FactoryDescriptor(Attributes attributes) throws MetaException {
        super(attributes);
        this.c_api = this.buildDependents(attributes, API_KEY);
        this.c_spi = this.buildDependents(attributes, SPI_KEY);
        this.c_imp = this.buildDependents(attributes, IMP_KEY);
        this.m_factory = this.getFactory(attributes);
        this.m_interface = this.getInterface(attributes);
    }

    public String getFactory() {
        return this.m_factory;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public Artifact[] getDependencies(String key) {
        if (key == API_KEY) {
            return this.c_api;
        }
        if (key == SPI_KEY) {
            return this.c_spi;
        }
        if (key == IMP_KEY) {
            return this.c_imp;
        }
        String error = "Invalid dependency key: " + key;
        throw new IllegalArgumentException(error);
    }

    public Artifact[] getDependencies() {
        int i;
        int j = this.c_api.length + this.c_spi.length + this.c_imp.length;
        Artifact[] all = new Artifact[j];
        int q = 0;
        for (i = 0; i < this.c_api.length; ++i) {
            all[q] = this.c_api[i];
            ++q;
        }
        for (i = 0; i < this.c_spi.length; ++i) {
            all[q] = this.c_spi[i];
            ++q;
        }
        for (i = 0; i < this.c_imp.length; ++i) {
            all[q] = this.c_imp[i];
            ++q;
        }
        return all;
    }

    public String toString() {
        return "[factory:" + this.m_factory + "]";
    }

    private Artifact[] buildDependents(Attributes attributes, String key) {
        try {
            Attribute attribute = attributes.get(key);
            if (null == attribute) {
                return new Artifact[0];
            }
            Artifact[] dependencies = new Artifact[attribute.size()];
            for (int i = 0; i < dependencies.length; ++i) {
                String spec = (String)attribute.get(i);
                dependencies[i] = Artifact.createArtifact((String)spec);
            }
            return dependencies;
        }
        catch (NamingException e) {
            throw new RepositoryRuntimeException("Failed to resolve dependencies for [" + key + "] on the attribute set [" + attributes + "].", (Throwable)e);
        }
    }

    private String getFactory(Attributes attributes) {
        try {
            return this.getValue(attributes, FACTORY_KEY);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private String getInterface(Attributes attributes) {
        try {
            return this.getValue(attributes, EXPORT_KEY);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

