/*
* Copyright 2004,2005 The Apache Software Foundation.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/


package org.apache.axis2.description;

import org.apache.axis2.AxisFault;
import org.apache.axis2.om.OMElement;

import javax.xml.namespace.QName;
import java.util.ArrayList;

/**
 * This is to store deployment time data , described by
 * <moduleConfig module="modulename">
 * <parameter> ....</parameter>
 * </moduleConfig>
 * <p/>
 * Right now this just keeps stores the set of parameters 
 */
public class ModuleConfiguration implements ParameterInclude {
    private QName moduleName;
    private ParameterInclude parameterinclude;

    // to keep the pointer to its parent , only to access parameters
    private ParameterInclude parent;

    public ModuleConfiguration(QName moduleName, ParameterInclude parent) {
        this.moduleName = moduleName;
        this.parent = parent;
        parameterinclude = new ParameterIncludeImpl();
    }

    public void addParameter(Parameter param) throws AxisFault {
        if (isParameterLocked(param.getName())) {
            throw new AxisFault("Parmter is locked can not overide: " + param.getName());
        } else {
            parameterinclude.addParameter(param);
        }
    }

    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterinclude.deserializeParameters(parameterElement);
    }

    public QName getModuleName() {
        return moduleName;
    }

    public Parameter getParameter(String name) {
        return parameterinclude.getParameter(name);
    }

    public ArrayList getParameters() {
        return parameterinclude.getParameters();
    }

    public boolean isParameterLocked(String parameterName) {

        // checking the locked value of parent
        boolean loscked = false;

        if (parent != null) {
            loscked = parent.isParameterLocked(parameterName);
        }

        if (loscked) {
            return true;
        } else {
            Parameter parameter = getParameter(parameterName);

            return (parameter != null) && parameter.isLocked();
        }
    }
}
