/*
* Copyright 2004,2005 The Apache Software Foundation.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/


package org.apache.axis2.transport;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;

/**
 * Class TransportListener
 */
public abstract class TransportListener {
    public static final String PARAM_PORT = "port";

    public abstract void init(ConfigurationContext axisConf, TransportInDescription transprtIn)
            throws AxisFault;

    public abstract void start() throws AxisFault;

    public abstract void stop() throws AxisFault;

    public abstract EndpointReference getReplyToEPR(String serviceName) throws AxisFault;
}
