/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util;

import be.atbash.util.PublicAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

@PublicAPI
public final class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final char DEFAULT_DELIMITER_CHAR = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';

    private StringUtils() {
    }

    public static boolean hasText(String str) {
        if (!StringUtils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String value) {
        return !StringUtils.hasText(value);
    }

    public static boolean isEmpty(char[] value) {
        if (value == null) {
            return true;
        }
        return !StringUtils.hasText(new String(value));
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static String clean(String in) {
        String out = in;
        if (in != null && (out = in.trim()).equals(EMPTY_STRING)) {
            out = null;
        }
        return out;
    }

    public static String toDelimitedString(Object[] array) {
        return StringUtils.toDelimitedString(",", array);
    }

    public static String toDelimitedString(String delimiter, Object ... array) {
        if (array == null || array.length == 0) {
            return EMPTY_STRING;
        }
        return StringUtils.toDelimitedString(delimiter, Arrays.asList(array));
    }

    public static String toDelimitedString(String delimiter, Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return EMPTY_STRING;
        }
        return StringUtils.toDelimitedString(delimiter, collection.iterator());
    }

    public static String toDelimitedString(String separator, Iterator<?> iterator) {
        String empty = EMPTY_STRING;
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return empty;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first == null ? empty : first.toString();
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] split(String aLine) {
        return StringUtils.split(aLine, ',');
    }

    public static String[] split(String aLine, char delimiter) {
        return StringUtils.split(aLine, delimiter, '\"');
    }

    public static String[] split(String aLine, char delimiter, char quoteChar) {
        return StringUtils.split(aLine, delimiter, quoteChar, quoteChar);
    }

    public static String[] split(String aLine, char delimiter, char beginQuoteChar, char endQuoteChar) {
        return StringUtils.split(aLine, delimiter, beginQuoteChar, endQuoteChar, false, true);
    }

    public static String[] split(String aLine, char delimiter, char beginQuoteChar, char endQuoteChar, boolean retainQuotes, boolean trimTokens) {
        String line = StringUtils.clean(aLine);
        if (line == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == beginQuoteChar) {
                if (inQuotes && line.length() > i + 1 && line.charAt(i + 1) == beginQuoteChar) {
                    sb.append(line.charAt(i + 1));
                    ++i;
                    continue;
                }
                boolean bl = inQuotes = !inQuotes;
                if (!retainQuotes) continue;
                sb.append(c);
                continue;
            }
            if (c == endQuoteChar) {
                boolean bl = inQuotes = !inQuotes;
                if (!retainQuotes) continue;
                sb.append(c);
                continue;
            }
            if (c == delimiter && !inQuotes) {
                String s = sb.toString();
                if (trimTokens) {
                    s = s.trim();
                }
                tokens.add(s);
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        String s = sb.toString();
        if (trimTokens) {
            s = s.trim();
        }
        tokens.add(s);
        return tokens.toArray(new String[tokens.size()]);
    }

    public static int countOccurrences(String haystack, char needle) {
        int count = 0;
        if (haystack == null) {
            return count;
        }
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }
}

