/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util.base64;

import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import be.atbash.util.codec.CodecSupport;
import java.util.Arrays;

@PublicAPI
public final class Base64Codec {
    private static final char[] CA;
    private static final char[] CA_URL_SAFE;
    private static final String VALID_NON_CA = "\n\r=";
    private static final int[] IA;
    private static final int[] IA_URL_SAFE;

    private Base64Codec() {
    }

    public static boolean isBase64Encoded(String value) {
        int separatorCount = 0;
        boolean allValidChars = true;
        for (int i = 0; i < value.length() && allValidChars; ++i) {
            char c = value.charAt(i);
            char b = c;
            if (b < '\u0100') {
                if (IA[c] != -1 || IA_URL_SAFE[c] != -1) continue;
                ++separatorCount;
                if (VALID_NON_CA.contains(String.valueOf(c))) continue;
                allValidChars = false;
                continue;
            }
            allValidChars = false;
        }
        if (!allValidChars) {
            return false;
        }
        return (value.length() - separatorCount) % 4 == 0;
    }

    public static boolean isBase64Encoded(byte[] value) {
        return Base64Codec.isBase64Encoded(CodecSupport.toString(value));
    }

    public static int computeEncodedLength(int inputLength, boolean urlSafe) {
        if (inputLength == 0) {
            return 0;
        }
        if (urlSafe) {
            int fullQuadLength = inputLength / 3 << 2;
            int remainder = inputLength % 3;
            return remainder == 0 ? fullQuadLength : fullQuadLength + remainder + 1;
        }
        return (inputLength - 1) / 3 + 1 << 2;
    }

    public static String normalizeEncodedString(String value) {
        int i;
        int inputLen = value.length();
        int legalLen = inputLen - Base64Codec.countIllegalChars(value);
        int padLength = legalLen % 4 == 0 ? 0 : 4 - legalLen % 4;
        char[] chars = new char[inputLen + padLength];
        value.getChars(0, inputLen, chars, 0);
        for (i = 0; i < padLength; ++i) {
            chars[inputLen + i] = 61;
        }
        for (i = 0; i < inputLen; ++i) {
            if (chars[i] == '_') {
                chars[i] = 47;
                continue;
            }
            if (chars[i] != '-') continue;
            chars[i] = 43;
        }
        return new String(chars);
    }

    private static int countIllegalChars(String b64String) {
        int illegalCharCount = 0;
        for (int i = 0; i < b64String.length(); ++i) {
            char c = b64String.charAt(i);
            if (IA[c] != -1 || IA_URL_SAFE[c] != -1) continue;
            ++illegalCharCount;
        }
        return illegalCharCount;
    }

    public static char[] encodeToChar(byte[] byteArray, boolean urlSafe) {
        int sLen;
        int n = sLen = byteArray != null ? byteArray.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int dLen = Base64Codec.computeEncodedLength(sLen, urlSafe);
        char[] out = new char[dLen];
        int s = 0;
        int d = 0;
        while (s < eLen) {
            int i = (byteArray[s++] & 0xFF) << 16 | (byteArray[s++] & 0xFF) << 8 | byteArray[s++] & 0xFF;
            if (urlSafe) {
                out[d++] = CA_URL_SAFE[i >>> 18 & 0x3F];
                out[d++] = CA_URL_SAFE[i >>> 12 & 0x3F];
                out[d++] = CA_URL_SAFE[i >>> 6 & 0x3F];
                out[d++] = CA_URL_SAFE[i & 0x3F];
                continue;
            }
            out[d++] = CA[i >>> 18 & 0x3F];
            out[d++] = CA[i >>> 12 & 0x3F];
            out[d++] = CA[i >>> 6 & 0x3F];
            out[d++] = CA[i & 0x3F];
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (byteArray[eLen] & 0xFF) << 10 | (left == 2 ? (byteArray[sLen - 1] & 0xFF) << 2 : 0);
            if (urlSafe) {
                if (left == 2) {
                    out[dLen - 3] = CA_URL_SAFE[i >> 12];
                    out[dLen - 2] = CA_URL_SAFE[i >>> 6 & 0x3F];
                    out[dLen - 1] = CA_URL_SAFE[i & 0x3F];
                } else {
                    out[dLen - 2] = CA_URL_SAFE[i >> 12];
                    out[dLen - 1] = CA_URL_SAFE[i >>> 6 & 0x3F];
                }
            } else {
                out[dLen - 4] = CA[i >> 12];
                out[dLen - 3] = CA[i >>> 6 & 0x3F];
                out[dLen - 2] = left == 2 ? CA[i & 0x3F] : 61;
                out[dLen - 1] = 61;
            }
        }
        return out;
    }

    public static String encodeToString(byte[] byteArray, boolean urlSafe) {
        return new String(Base64Codec.encodeToChar(byteArray, urlSafe));
    }

    public static byte[] decode(String value) {
        int sepCnt;
        if (StringUtils.isEmpty(value)) {
            return new byte[0];
        }
        String nStr = Base64Codec.normalizeEncodedString(value);
        int sLen = nStr.length();
        if ((sLen - (sepCnt = Base64Codec.countIllegalChars(nStr))) % 4 != 0) {
            return new byte[0];
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && IA[nStr.charAt(--i)] <= 0) {
            if (nStr.charAt(i) != '=') continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = IA[nStr.charAt(s++)]) >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    public static byte[] decode(byte[] value) {
        return Base64Codec.decode(CodecSupport.toString(value));
    }

    static {
        int i;
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        CA_URL_SAFE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
        IA = new int[256];
        IA_URL_SAFE = new int[256];
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            Base64Codec.IA[Base64Codec.CA[i]] = i;
        }
        Base64Codec.IA[61] = 0;
        Arrays.fill(IA_URL_SAFE, -1);
        iS = CA_URL_SAFE.length;
        for (i = 0; i < iS; ++i) {
            Base64Codec.IA_URL_SAFE[Base64Codec.CA_URL_SAFE[i]] = i;
        }
        Base64Codec.IA_URL_SAFE[61] = 0;
    }
}

